/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedBiasAdd<V>
extends PrimitiveOp {
    private Output<V> output;
    private Output<Float> minOut;
    private Output<Float> maxOut;

    public static <V, T, U> QuantizedBiasAdd<V> create(Scope scope, Operand<T> input, Operand<U> bias, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minBias, Operand<Float> maxBias, Class<V> outType) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedBiasAdd", scope.makeOpName("QuantizedBiasAdd"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(bias.asOutput());
        operationBuilder.addInput(minInput.asOutput());
        operationBuilder.addInput(maxInput.asOutput());
        operationBuilder.addInput(minBias.asOutput());
        operationBuilder.addInput(maxBias.asOutput());
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new QuantizedBiasAdd<V>(operationBuilder.build());
    }

    public final Output<V> output() {
        return this.output;
    }

    public final Output<Float> minOut() {
        return this.minOut;
    }

    public final Output<Float> maxOut() {
        return this.maxOut;
    }

    private QuantizedBiasAdd(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.minOut = operation.output(1);
        this.maxOut = operation.output(2);
    }
}

