/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ReduceJoin
extends PrimitiveOp
implements Operand<String> {
    private Output<String> output;

    public static ReduceJoin create(Scope scope, Operand<String> inputs, Operand<Integer> reductionIndices, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ReduceJoin", scope.makeOpName("ReduceJoin"));
        operationBuilder.addInput(inputs.asOutput());
        operationBuilder.addInput(reductionIndices.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.keepDims != null) {
                    operationBuilder.setAttr("keep_dims", options2.keepDims);
                }
                if (options2.separator == null) continue;
                operationBuilder.setAttr("separator", options2.separator);
            }
        }
        return new ReduceJoin(operationBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public static Options separator(String separator) {
        return new Options().separator(separator);
    }

    public final Output<String> output() {
        return this.output;
    }

    @Override
    public final Output<String> asOutput() {
        return this.output;
    }

    private ReduceJoin(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean keepDims;
        private String separator;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        public Options separator(String separator) {
            this.separator = separator;
            return this;
        }

        private Options() {
        }
    }
}

