/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResourceGather<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> output;

    public static <U, T extends Number> ResourceGather<U> create(Scope scope, Operand<?> resource, Operand<T> indices, Class<U> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ResourceGather", scope.makeOpName("ResourceGather"));
        operationBuilder.addInput(resource.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.validateIndices == null) continue;
                operationBuilder.setAttr("validate_indices", options2.validateIndices);
            }
        }
        return new ResourceGather<U>(operationBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public final Output<U> output() {
        return this.output;
    }

    @Override
    public final Output<U> asOutput() {
        return this.output;
    }

    private ResourceGather(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

