/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResourceSparseApplyMomentum
extends PrimitiveOp {
    public static <T, U extends Number> ResourceSparseApplyMomentum create(Scope scope, Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ResourceSparseApplyMomentum", scope.makeOpName("ResourceSparseApplyMomentum"));
        operationBuilder.addInput(var.asOutput());
        operationBuilder.addInput(accum.asOutput());
        operationBuilder.addInput(lr.asOutput());
        operationBuilder.addInput(grad.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInput(momentum.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.useLocking != null) {
                    operationBuilder.setAttr("use_locking", options2.useLocking);
                }
                if (options2.useNesterov == null) continue;
                operationBuilder.setAttr("use_nesterov", options2.useNesterov);
            }
        }
        return new ResourceSparseApplyMomentum(operationBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options useNesterov(Boolean useNesterov) {
        return new Options().useNesterov(useNesterov);
    }

    private ResourceSparseApplyMomentum(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean useNesterov;

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options useNesterov(Boolean useNesterov) {
            this.useNesterov = useNesterov;
            return this;
        }

        private Options() {
        }
    }
}

