/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseMatMul
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> product;

    public static <T extends Number, U extends Number> SparseMatMul create(Scope scope, Operand<T> a2, Operand<U> b2, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseMatMul", scope.makeOpName("SparseMatMul"));
        operationBuilder.addInput(a2.asOutput());
        operationBuilder.addInput(b2.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.transposeA != null) {
                    operationBuilder.setAttr("transpose_a", options2.transposeA);
                }
                if (options2.transposeB != null) {
                    operationBuilder.setAttr("transpose_b", options2.transposeB);
                }
                if (options2.aIsSparse != null) {
                    operationBuilder.setAttr("a_is_sparse", options2.aIsSparse);
                }
                if (options2.bIsSparse == null) continue;
                operationBuilder.setAttr("b_is_sparse", options2.bIsSparse);
            }
        }
        return new SparseMatMul(operationBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options aIsSparse(Boolean aIsSparse) {
        return new Options().aIsSparse(aIsSparse);
    }

    public static Options bIsSparse(Boolean bIsSparse) {
        return new Options().bIsSparse(bIsSparse);
    }

    public final Output<Float> product() {
        return this.product;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.product;
    }

    private SparseMatMul(Operation operation) {
        super(operation);
        this.product = operation.output(0);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private Boolean aIsSparse;
        private Boolean bIsSparse;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options aIsSparse(Boolean aIsSparse) {
            this.aIsSparse = aIsSparse;
            return this;
        }

        public Options bIsSparse(Boolean bIsSparse) {
            this.bIsSparse = bIsSparse;
            return this;
        }

        private Options() {
        }
    }
}

