/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class StringSplitV2
extends PrimitiveOp {
    private Output<Long> indices;
    private Output<String> values;
    private Output<Long> shape;

    public static StringSplitV2 create(Scope scope, Operand<String> input, Operand<String> sep, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("StringSplitV2", scope.makeOpName("StringSplitV2"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(sep.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.maxsplit == null) continue;
                operationBuilder.setAttr("maxsplit", options2.maxsplit);
            }
        }
        return new StringSplitV2(operationBuilder.build());
    }

    public static Options maxsplit(Long maxsplit) {
        return new Options().maxsplit(maxsplit);
    }

    public final Output<Long> indices() {
        return this.indices;
    }

    public final Output<String> values() {
        return this.values;
    }

    public final Output<Long> shape() {
        return this.shape;
    }

    private StringSplitV2(Operation operation) {
        super(operation);
        this.indices = operation.output(0);
        this.values = operation.output(1);
        this.shape = operation.output(2);
    }

    public static class Options {
        private Long maxsplit;

        public Options maxsplit(Long maxsplit) {
            this.maxsplit = maxsplit;
            return this;
        }

        private Options() {
        }
    }
}

