/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPath;
import ai.h2o.javassist.ClassPoolTail;
import ai.h2o.javassist.CtArray;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtClassType;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtNewClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.util.proxy.DefineClassHelper;
import ai.h2o.javassist.util.proxy.DefinePackageHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ClassPool {
    public boolean childFirstLookup = false;
    public static boolean doPruning = false;
    private int compressCount;
    private static final int COMPRESS_THRESHOLD = 100;
    public static boolean releaseUnmodifiedClassFile = true;
    protected ClassPoolTail source;
    protected ClassPool parent;
    protected Hashtable classes = new Hashtable(191);
    private Hashtable cflow = null;
    private static final int INIT_HASH_SIZE = 191;
    private ArrayList importedPackages;
    private static ClassPool defaultPool = null;

    public ClassPool() {
        this(null);
    }

    public ClassPool(boolean useDefaultPath) {
        this(null);
        if (useDefaultPath) {
            this.appendSystemPath();
        }
    }

    public ClassPool(ClassPool parent) {
        this.source = new ClassPoolTail();
        this.parent = parent;
        if (parent == null) {
            CtClass[] ctClassArray = CtClass.primitiveTypes;
            for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                this.classes.put(ctClassArray[i2].getName(), ctClassArray[i2]);
            }
        }
        this.cflow = null;
        this.compressCount = 0;
        this.clearImportedPackages();
    }

    public static synchronized ClassPool getDefault() {
        if (defaultPool == null) {
            defaultPool = new ClassPool(null);
            defaultPool.appendSystemPath();
        }
        return defaultPool;
    }

    protected CtClass getCached(String classname) {
        return (CtClass)this.classes.get(classname);
    }

    protected void cacheCtClass(String classname, CtClass c2, boolean dynamic) {
        this.classes.put(classname, c2);
    }

    protected CtClass removeCached(String classname) {
        return (CtClass)this.classes.remove(classname);
    }

    public String toString() {
        return this.source.toString();
    }

    void compress() {
        if (this.compressCount++ > 100) {
            this.compressCount = 0;
            Enumeration enumeration = this.classes.elements();
            while (enumeration.hasMoreElements()) {
                ((CtClass)enumeration.nextElement()).compress();
            }
        }
    }

    public void importPackage(String packageName) {
        this.importedPackages.add(packageName);
    }

    public void clearImportedPackages() {
        this.importedPackages = new ArrayList();
        this.importedPackages.add("java.lang");
    }

    public Iterator<String> getImportedPackages() {
        return this.importedPackages.iterator();
    }

    public void recordInvalidClassName(String name) {
    }

    void recordCflow(String name, String cname, String fname) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        this.cflow.put(name, new Object[]{cname, fname});
    }

    public Object[] lookupCflow(String name) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        return (Object[])this.cflow.get(name);
    }

    public CtClass getAndRename(String orgName, String newName) throws NotFoundException {
        CtClass ctClass = this.get0(orgName, false);
        if (ctClass == null) {
            throw new NotFoundException(orgName);
        }
        if (ctClass instanceof CtClassType) {
            ((CtClassType)ctClass).setClassPool(this);
        }
        ctClass.setName(newName);
        return ctClass;
    }

    synchronized void classNameChanged(String oldname, CtClass clazz) {
        CtClass ctClass = this.getCached(oldname);
        if (ctClass == clazz) {
            this.removeCached(oldname);
        }
        String string = clazz.getName();
        this.checkNotFrozen(string);
        this.cacheCtClass(string, clazz, false);
    }

    public CtClass get(String classname) throws NotFoundException {
        CtClass ctClass = classname == null ? null : this.get0(classname, true);
        if (ctClass == null) {
            throw new NotFoundException(classname);
        }
        ctClass.incGetCounter();
        return ctClass;
    }

    public CtClass getOrNull(String classname) {
        CtClass ctClass = null;
        if (classname == null) {
            ctClass = null;
        } else {
            try {
                ctClass = this.get0(classname, true);
            }
            catch (NotFoundException notFoundException) {}
        }
        if (ctClass != null) {
            ctClass.incGetCounter();
        }
        return ctClass;
    }

    public CtClass getCtClass(String classname) throws NotFoundException {
        if (classname.charAt(0) == '[') {
            return Descriptor.toCtClass(classname, this);
        }
        return this.get(classname);
    }

    protected synchronized CtClass get0(String classname, boolean useCache) throws NotFoundException {
        CtClass clazz;
        if (useCache && (clazz = this.getCached(classname)) != null) {
            return clazz;
        }
        if (!this.childFirstLookup && this.parent != null && (clazz = this.parent.get0(classname, useCache)) != null) {
            return clazz;
        }
        clazz = this.createCtClass(classname, useCache);
        if (clazz != null) {
            if (useCache) {
                this.cacheCtClass(clazz.getName(), clazz, false);
            }
            return clazz;
        }
        if (this.childFirstLookup && this.parent != null) {
            clazz = this.parent.get0(classname, useCache);
        }
        return clazz;
    }

    protected CtClass createCtClass(String classname, boolean useCache) {
        if (classname.charAt(0) == '[') {
            classname = Descriptor.toClassName(classname);
        }
        if (classname.endsWith("[]")) {
            String string = classname.substring(0, classname.indexOf(91));
            if (!(useCache && this.getCached(string) != null || this.find(string) != null)) {
                return null;
            }
            return new CtArray(classname, this);
        }
        if (this.find(classname) == null) {
            return null;
        }
        return new CtClassType(classname, this);
    }

    public URL find(String classname) {
        return this.source.find(classname);
    }

    void checkNotFrozen(String classname) throws RuntimeException {
        CtClass ctClass = this.getCached(classname);
        if (ctClass == null) {
            if (!this.childFirstLookup && this.parent != null) {
                try {
                    ctClass = this.parent.get0(classname, true);
                }
                catch (NotFoundException notFoundException) {}
                if (ctClass != null) {
                    throw new RuntimeException(classname + " is in a parent ClassPool.  Use the parent.");
                }
            }
        } else if (ctClass.isFrozen()) {
            throw new RuntimeException(classname + ": frozen class (cannot edit)");
        }
    }

    CtClass checkNotExists(String classname) {
        CtClass ctClass = this.getCached(classname);
        if (ctClass == null && !this.childFirstLookup && this.parent != null) {
            try {
                ctClass = this.parent.get0(classname, true);
            }
            catch (NotFoundException notFoundException) {}
        }
        return ctClass;
    }

    InputStream openClassfile(String classname) throws NotFoundException {
        return this.source.openClassfile(classname);
    }

    void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        this.source.writeClassfile(classname, out);
    }

    public CtClass[] get(String[] classnames) throws NotFoundException {
        if (classnames == null) {
            return new CtClass[0];
        }
        int n2 = classnames.length;
        CtClass[] ctClassArray = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctClassArray[i2] = this.get(classnames[i2]);
        }
        return ctClassArray;
    }

    public CtMethod getMethod(String classname, String methodname) throws NotFoundException {
        CtClass ctClass = this.get(classname);
        return ctClass.getDeclaredMethod(methodname);
    }

    public CtClass makeClass(InputStream classfile) throws IOException, RuntimeException {
        return this.makeClass(classfile, true);
    }

    public CtClass makeClass(InputStream classfile, boolean ifNotFrozen) throws IOException, RuntimeException {
        this.compress();
        classfile = new BufferedInputStream(classfile);
        CtClassType ctClassType = new CtClassType(classfile, this);
        ((CtClass)ctClassType).checkModify();
        String string = ctClassType.getName();
        if (ifNotFrozen) {
            this.checkNotFrozen(string);
        }
        this.cacheCtClass(string, ctClassType, true);
        return ctClassType;
    }

    public CtClass makeClass(ClassFile classfile) throws RuntimeException {
        return this.makeClass(classfile, true);
    }

    public CtClass makeClass(ClassFile classfile, boolean ifNotFrozen) throws RuntimeException {
        this.compress();
        CtClassType ctClassType = new CtClassType(classfile, this);
        ((CtClass)ctClassType).checkModify();
        String string = ctClassType.getName();
        if (ifNotFrozen) {
            this.checkNotFrozen(string);
        }
        this.cacheCtClass(string, ctClassType, true);
        return ctClassType;
    }

    public CtClass makeClassIfNew(InputStream classfile) throws IOException, RuntimeException {
        this.compress();
        classfile = new BufferedInputStream(classfile);
        CtClassType ctClassType = new CtClassType(classfile, this);
        ((CtClass)ctClassType).checkModify();
        String string = ctClassType.getName();
        CtClass ctClass = this.checkNotExists(string);
        if (ctClass != null) {
            return ctClass;
        }
        this.cacheCtClass(string, ctClassType, true);
        return ctClassType;
    }

    public CtClass makeClass(String classname) throws RuntimeException {
        return this.makeClass(classname, null);
    }

    public synchronized CtClass makeClass(String classname, CtClass superclass) throws RuntimeException {
        this.checkNotFrozen(classname);
        CtNewClass ctNewClass = new CtNewClass(classname, this, false, superclass);
        this.cacheCtClass(classname, ctNewClass, true);
        return ctNewClass;
    }

    synchronized CtClass makeNestedClass(String classname) {
        this.checkNotFrozen(classname);
        CtNewClass ctNewClass = new CtNewClass(classname, this, false, null);
        this.cacheCtClass(classname, ctNewClass, true);
        return ctNewClass;
    }

    public CtClass makeInterface(String name) throws RuntimeException {
        return this.makeInterface(name, null);
    }

    public synchronized CtClass makeInterface(String name, CtClass superclass) throws RuntimeException {
        this.checkNotFrozen(name);
        CtNewClass ctNewClass = new CtNewClass(name, this, true, superclass);
        this.cacheCtClass(name, ctNewClass, true);
        return ctNewClass;
    }

    public CtClass makeAnnotation(String name) throws RuntimeException {
        try {
            CtClass ctClass = this.makeInterface(name, this.get("java.lang.annotation.Annotation"));
            ctClass.setModifiers(ctClass.getModifiers() | 0x2000);
            return ctClass;
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException.getMessage(), notFoundException);
        }
    }

    public ClassPath appendSystemPath() {
        return this.source.appendSystemPath();
    }

    public ClassPath insertClassPath(ClassPath cp) {
        return this.source.insertClassPath(cp);
    }

    public ClassPath appendClassPath(ClassPath cp) {
        return this.source.appendClassPath(cp);
    }

    public ClassPath insertClassPath(String pathname) throws NotFoundException {
        return this.source.insertClassPath(pathname);
    }

    public ClassPath appendClassPath(String pathname) throws NotFoundException {
        return this.source.appendClassPath(pathname);
    }

    public void removeClassPath(ClassPath cp) {
        this.source.removeClassPath(cp);
    }

    public void appendPathList(String pathlist) throws NotFoundException {
        char c2 = File.pathSeparatorChar;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = pathlist.indexOf(c2, n2)) < 0) {
                this.appendClassPath(pathlist.substring(n2));
                return;
            }
            this.appendClassPath(pathlist.substring(n2, n3));
            n2 = n3 + 1;
        }
    }

    public Class toClass(CtClass clazz) throws CannotCompileException {
        return this.toClass(clazz, this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return ClassPool.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Class toClass(CtClass ct, ClassLoader loader) throws CannotCompileException {
        return this.toClass(ct, null, loader, null);
    }

    public Class toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        return this.toClass(ct, null, loader, domain);
    }

    public Class<?> toClass(CtClass ct, Class<?> neighbor) throws CannotCompileException {
        try {
            return DefineClassHelper.toClass(neighbor, ct.toBytecode());
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    public Class<?> toClass(CtClass ct, MethodHandles.Lookup lookup) throws CannotCompileException {
        try {
            return DefineClassHelper.toClass(lookup, ct.toBytecode());
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    public Class toClass(CtClass ct, Class<?> neighbor, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        try {
            return DefineClassHelper.toClass(ct.getName(), neighbor, loader, domain, ct.toBytecode());
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    public void makePackage(ClassLoader loader, String name) throws CannotCompileException {
        DefinePackageHelper.definePackage(name, loader);
    }
}

