/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassMap;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CodeConverter;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtClassType;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMember;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.AccessFlag;
import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.LineNumberAttribute;
import ai.h2o.javassist.bytecode.LocalVariableAttribute;
import ai.h2o.javassist.bytecode.LocalVariableTypeAttribute;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.ParameterAnnotationsAttribute;
import ai.h2o.javassist.bytecode.SignatureAttribute;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;
import ai.h2o.javassist.expr.ExprEditor;

public abstract class CtBehavior
extends CtMember {
    protected MethodInfo methodInfo;

    protected CtBehavior(CtClass clazz, MethodInfo minfo) {
        super(clazz);
        this.methodInfo = minfo;
    }

    void copy(CtBehavior src, boolean isCons, ClassMap map) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        MethodInfo methodInfo = src.methodInfo;
        CtClass ctClass2 = src.getDeclaringClass();
        ConstPool constPool = ctClass.getClassFile2().getConstPool();
        map = new ClassMap(map);
        map.put(ctClass2.getName(), ctClass.getName());
        try {
            String string;
            boolean bl = false;
            CtClass ctClass3 = ctClass2.getSuperclass();
            CtClass ctClass4 = ctClass.getSuperclass();
            String string2 = null;
            if (ctClass3 != null && ctClass4 != null && !(string = ctClass3.getName()).equals(string2 = ctClass4.getName())) {
                if (string.equals("java.lang.Object")) {
                    bl = true;
                } else {
                    map.putIfNone(string, string2);
                }
            }
            this.methodInfo = new MethodInfo(constPool, methodInfo.getName(), methodInfo, map);
            if (isCons && bl) {
                this.methodInfo.setSuperclass(string2);
            }
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    @Override
    protected void extendToString(StringBuffer buffer) {
        buffer.append(' ');
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append(this.methodInfo.getDescriptor());
    }

    public abstract String getLongName();

    public MethodInfo getMethodInfo() {
        this.declaringClass.checkModify();
        return this.methodInfo;
    }

    public MethodInfo getMethodInfo2() {
        return this.methodInfo;
    }

    @Override
    public int getModifiers() {
        return AccessFlag.toModifier(this.methodInfo.getAccessFlags());
    }

    @Override
    public void setModifiers(int mod) {
        this.declaringClass.checkModify();
        this.methodInfo.setAccessFlags(AccessFlag.of(mod));
    }

    @Override
    public boolean hasAnnotation(String typeName) {
        MethodInfo methodInfo = this.getMethodInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(typeName, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    @Override
    public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
        MethodInfo methodInfo = this.getMethodInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clz, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    @Override
    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    @Override
    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception", classNotFoundException);
        }
    }

    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        MethodInfo methodInfo = this.getMethodInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    public Object[][] getParameterAnnotations() throws ClassNotFoundException {
        return this.getParameterAnnotations(false);
    }

    public Object[][] getAvailableParameterAnnotations() {
        try {
            return this.getParameterAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception", classNotFoundException);
        }
    }

    Object[][] getParameterAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        MethodInfo methodInfo = this.getMethodInfo2();
        ParameterAnnotationsAttribute parameterAnnotationsAttribute = (ParameterAnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleParameterAnnotations");
        ParameterAnnotationsAttribute parameterAnnotationsAttribute2 = (ParameterAnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleParameterAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getDeclaringClass().getClassPool(), parameterAnnotationsAttribute, parameterAnnotationsAttribute2, methodInfo);
    }

    public CtClass[] getParameterTypes() throws NotFoundException {
        return Descriptor.getParameterTypes(this.methodInfo.getDescriptor(), this.declaringClass.getClassPool());
    }

    CtClass getReturnType0() throws NotFoundException {
        return Descriptor.getReturnType(this.methodInfo.getDescriptor(), this.declaringClass.getClassPool());
    }

    @Override
    public String getSignature() {
        return this.methodInfo.getDescriptor();
    }

    @Override
    public String getGenericSignature() {
        SignatureAttribute signatureAttribute = (SignatureAttribute)this.methodInfo.getAttribute("Signature");
        if (signatureAttribute == null) {
            return null;
        }
        return signatureAttribute.getSignature();
    }

    @Override
    public void setGenericSignature(String sig) {
        this.declaringClass.checkModify();
        this.methodInfo.addAttribute(new SignatureAttribute(this.methodInfo.getConstPool(), sig));
    }

    public CtClass[] getExceptionTypes() throws NotFoundException {
        ExceptionsAttribute exceptionsAttribute = this.methodInfo.getExceptionsAttribute();
        String[] stringArray = exceptionsAttribute == null ? null : exceptionsAttribute.getExceptions();
        return this.declaringClass.getClassPool().get(stringArray);
    }

    public void setExceptionTypes(CtClass[] types) throws NotFoundException {
        this.declaringClass.checkModify();
        if (types == null || types.length == 0) {
            this.methodInfo.removeExceptionsAttribute();
            return;
        }
        String[] stringArray = new String[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            stringArray[i2] = types[i2].getName();
        }
        ExceptionsAttribute exceptionsAttribute = this.methodInfo.getExceptionsAttribute();
        if (exceptionsAttribute == null) {
            exceptionsAttribute = new ExceptionsAttribute(this.methodInfo.getConstPool());
            this.methodInfo.setExceptionsAttribute(exceptionsAttribute);
        }
        exceptionsAttribute.setExceptions(stringArray);
    }

    public abstract boolean isEmpty();

    public void setBody(String src) throws CannotCompileException {
        this.setBody(src, null, null);
    }

    public void setBody(String src, String delegateObj, String delegateMethod) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        try {
            Javac javac = new Javac(ctClass);
            if (delegateMethod != null) {
                javac.recordProceed(delegateObj, delegateMethod);
            }
            Bytecode bytecode = javac.compileBody(this, src);
            this.methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            this.methodInfo.setAccessFlags(this.methodInfo.getAccessFlags() & 0xFFFFFBFF);
            this.methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            this.declaringClass.rebuildClassFile();
            return;
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    static void setBody0(CtClass srcClass, MethodInfo srcInfo, CtClass destClass, MethodInfo destInfo, ClassMap map) throws CannotCompileException {
        destClass.checkModify();
        map = new ClassMap(map);
        map.put(srcClass.getName(), destClass.getName());
        try {
            CodeAttribute codeAttribute = srcInfo.getCodeAttribute();
            if (codeAttribute != null) {
                ConstPool constPool = destInfo.getConstPool();
                CodeAttribute codeAttribute2 = (CodeAttribute)codeAttribute.copy(constPool, map);
                destInfo.setCodeAttribute(codeAttribute2);
            }
        }
        catch (CodeAttribute.RuntimeCopyException runtimeCopyException) {
            throw new CannotCompileException(runtimeCopyException);
        }
        MethodInfo methodInfo = destInfo;
        methodInfo.setAccessFlags(methodInfo.getAccessFlags() & 0xFFFFFBFF);
        destClass.rebuildClassFile();
    }

    @Override
    public byte[] getAttribute(String name) {
        AttributeInfo attributeInfo = this.methodInfo.getAttribute(name);
        if (attributeInfo == null) {
            return null;
        }
        return attributeInfo.get();
    }

    @Override
    public void setAttribute(String name, byte[] data) {
        this.declaringClass.checkModify();
        this.methodInfo.addAttribute(new AttributeInfo(this.methodInfo.getConstPool(), name, data));
    }

    public void useCflow(String name) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        ClassPool classPool = ctClass.getClassPool();
        int n2 = 0;
        while (true) {
            String string = "_cflow$" + n2++;
            try {
                ctClass.getDeclaredField(string);
            }
            catch (NotFoundException notFoundException) {
                classPool.recordCflow(name, this.declaringClass.getName(), string);
                try {
                    CtClass ctClass2 = classPool.get("ai.h2o.javassist.runtime.Cflow");
                    CtField ctField = new CtField(ctClass2, string, ctClass);
                    ctField.setModifiers(9);
                    ctClass.addField(ctField, CtField.Initializer.byNew(ctClass2));
                    this.insertBefore(string + ".enter();", false);
                    String string2 = string + ".exit();";
                    this.insertAfter(string2, true);
                    return;
                }
                catch (NotFoundException notFoundException2) {
                    throw new CannotCompileException(notFoundException2);
                }
            }
        }
    }

    public void addLocalVariable(String name, CtClass type) throws CannotCompileException {
        this.declaringClass.checkModify();
        ConstPool constPool = this.methodInfo.getConstPool();
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            throw new CannotCompileException("no method body");
        }
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            localVariableAttribute = new LocalVariableAttribute(constPool);
            codeAttribute.getAttributes().add(localVariableAttribute);
        }
        int n2 = codeAttribute.getMaxLocals();
        String string = Descriptor.of(type);
        localVariableAttribute.addEntry(0, codeAttribute.getCodeLength(), constPool.addUtf8Info(name), constPool.addUtf8Info(string), n2);
        codeAttribute.setMaxLocals(n2 + Descriptor.dataSize(string));
    }

    public void insertParameter(CtClass type) throws CannotCompileException {
        this.declaringClass.checkModify();
        String string = this.methodInfo.getDescriptor();
        String string2 = Descriptor.insertParameter(type, string);
        try {
            CtBehavior ctBehavior = this;
            ctBehavior.addParameter2(Modifier.isStatic(ctBehavior.getModifiers()) ? 0 : 1, type, string);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
        this.methodInfo.setDescriptor(string2);
    }

    public void addParameter(CtClass type) throws CannotCompileException {
        this.declaringClass.checkModify();
        String string = this.methodInfo.getDescriptor();
        String string2 = Descriptor.appendParameter(type, string);
        int n2 = Modifier.isStatic(this.getModifiers()) ? 0 : 1;
        try {
            this.addParameter2(n2 + Descriptor.paramSize(string), type, string);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
        this.methodInfo.setDescriptor(string2);
    }

    private void addParameter2(int where, CtClass type, String desc) throws BadBytecode {
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            StackMap stackMap;
            StackMapTable stackMapTable;
            LocalVariableTypeAttribute localVariableTypeAttribute;
            Object object;
            int n2 = 1;
            char c2 = 'L';
            int n3 = 0;
            if (type.isPrimitive()) {
                object = (CtPrimitiveType)type;
                n2 = ((CtPrimitiveType)object).getDataSize();
                c2 = ((CtPrimitiveType)object).getDescriptor();
            } else {
                n3 = this.methodInfo.getConstPool().addClassInfo(type);
            }
            codeAttribute.insertLocalVar(where, n2);
            object = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            if (object != null) {
                ((LocalVariableAttribute)object).shiftIndex(where, n2);
            }
            if ((localVariableTypeAttribute = (LocalVariableTypeAttribute)codeAttribute.getAttribute("LocalVariableTypeTable")) != null) {
                localVariableTypeAttribute.shiftIndex(where, n2);
            }
            if ((stackMapTable = (StackMapTable)codeAttribute.getAttribute("StackMapTable")) != null) {
                stackMapTable.insertLocal(where, StackMapTable.typeTagOf(c2), n3);
            }
            if ((stackMap = (StackMap)codeAttribute.getAttribute("StackMap")) != null) {
                stackMap.insertLocal(where, StackMapTable.typeTagOf(c2), n3);
            }
        }
    }

    public void instrument(CodeConverter converter) throws CannotCompileException {
        this.declaringClass.checkModify();
        ConstPool constPool = this.methodInfo.getConstPool();
        converter.doit(this.getDeclaringClass(), this.methodInfo, constPool);
    }

    public void instrument(ExprEditor editor) throws CannotCompileException {
        if (this.declaringClass.isFrozen()) {
            this.declaringClass.checkModify();
        }
        if (editor.doit(this.declaringClass, this.methodInfo)) {
            this.declaringClass.checkModify();
        }
    }

    public void insertBefore(String src) throws CannotCompileException {
        this.insertBefore(src, true);
    }

    private void insertBefore(String src, boolean rebuild) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            throw new CannotCompileException("no method body");
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        Javac javac = new Javac(ctClass);
        try {
            int n2 = javac.recordParams(this.getParameterTypes(), Modifier.isStatic(this.getModifiers()));
            javac.recordParamNames(codeAttribute, n2);
            javac.recordLocalVariables(codeAttribute, 0);
            javac.recordReturnType(this.getReturnType0(), false);
            javac.compileStmnt(src);
            Bytecode bytecode = javac.getBytecode();
            int n3 = bytecode.getMaxStack();
            int n4 = bytecode.getMaxLocals();
            if (n3 > codeAttribute.getMaxStack()) {
                codeAttribute.setMaxStack(n3);
            }
            if (n4 > codeAttribute.getMaxLocals()) {
                codeAttribute.setMaxLocals(n4);
            }
            int n5 = codeIterator.insertEx(bytecode.get());
            codeIterator.insert(bytecode.getExceptionTable(), n5);
            if (rebuild) {
                this.methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            }
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    public void insertAfter(String src) throws CannotCompileException {
        this.insertAfter(src, false);
    }

    public void insertAfter(String src, boolean asFinally) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        ConstPool constPool = this.methodInfo.getConstPool();
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            throw new CannotCompileException("no method body");
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        int n2 = codeAttribute.getMaxLocals();
        Bytecode bytecode = new Bytecode(constPool, 0, n2 + 1);
        bytecode.setStackDepth(codeAttribute.getMaxStack() + 1);
        Javac javac = new Javac(bytecode, ctClass);
        try {
            int n3;
            int n4 = javac.recordParams(this.getParameterTypes(), Modifier.isStatic(this.getModifiers()));
            javac.recordParamNames(codeAttribute, n4);
            CtClass ctClass2 = this.getReturnType0();
            int n5 = javac.recordReturnType(ctClass2, true);
            javac.recordLocalVariables(codeAttribute, 0);
            int n6 = this.insertAfterHandler(asFinally, bytecode, ctClass2, n5, javac, src);
            int n7 = codeIterator.getCodeLength();
            if (asFinally) {
                int n8 = n7;
                codeAttribute.getExceptionTable().add(this.getStartPosOfBody(codeAttribute), n8, n8, 0);
            }
            int n9 = 0;
            int n10 = 0;
            boolean bl = true;
            while (codeIterator.hasNext() && (n3 = codeIterator.next()) < n7) {
                int n11 = codeIterator.byteAt(n3);
                if (n11 != 176 && n11 != 172 && n11 != 174 && n11 != 173 && n11 != 175 && n11 != 177) continue;
                if (bl) {
                    n9 = this.insertAfterAdvice(bytecode, javac, src, constPool, ctClass2, n5);
                    n7 = codeIterator.append(bytecode.get());
                    codeIterator.append(bytecode.getExceptionTable(), n7);
                    n10 = codeIterator.getCodeLength() - n9;
                    n6 = n10 - n7;
                    bl = false;
                }
                this.insertGoto(codeIterator, n10, n3);
                n10 = codeIterator.getCodeLength() - n9;
                n7 = n10 - n6;
            }
            if (bl) {
                n7 = codeIterator.append(bytecode.get());
                codeIterator.append(bytecode.getExceptionTable(), n7);
            }
            codeAttribute.setMaxStack(bytecode.getMaxStack());
            codeAttribute.setMaxLocals(bytecode.getMaxLocals());
            this.methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    private int insertAfterAdvice(Bytecode code, Javac jv, String src, ConstPool cp, CtClass rtype, int varNo) throws CompileError {
        int n2 = code.currentPc();
        if (rtype == CtClass.voidType) {
            code.addOpcode(1);
            code.addAstore(varNo);
            jv.compileStmnt(src);
            code.addOpcode(177);
            if (code.getMaxLocals() <= 0) {
                code.setMaxLocals(1);
            }
        } else {
            code.addStore(varNo, rtype);
            jv.compileStmnt(src);
            code.addLoad(varNo, rtype);
            if (rtype.isPrimitive()) {
                code.addOpcode(((CtPrimitiveType)rtype).getReturnOp());
            } else {
                code.addOpcode(176);
            }
        }
        return code.currentPc() - n2;
    }

    private void insertGoto(CodeIterator iterator, int subr, int pos) throws BadBytecode {
        iterator.setMark(subr);
        iterator.writeByte(0, pos);
        boolean bl = subr + 2 - pos > Short.MAX_VALUE;
        int n2 = bl ? 4 : 2;
        CodeIterator.Gap gap = iterator.insertGapAt(pos, n2, false);
        pos = gap.position + gap.length - n2;
        int n3 = iterator.getMark() - pos;
        if (bl) {
            iterator.writeByte(200, pos);
            iterator.write32bit(n3, pos + 1);
            return;
        }
        if (n3 <= Short.MAX_VALUE) {
            iterator.writeByte(167, pos);
            iterator.write16bit(n3, pos + 1);
            return;
        }
        if (gap.length < 4) {
            CodeIterator.Gap gap2 = iterator.insertGapAt(gap.position, 2, false);
            pos = gap2.position + gap2.length + gap.length - 4;
        }
        iterator.writeByte(200, pos);
        CodeIterator codeIterator = iterator;
        codeIterator.write32bit(codeIterator.getMark() - pos, pos + 1);
    }

    private int insertAfterHandler(boolean asFinally, Bytecode b2, CtClass rtype, int returnVarNo, Javac javac, String src) throws CompileError {
        if (!asFinally) {
            return 0;
        }
        int n2 = b2.getMaxLocals();
        b2.incMaxLocals(1);
        int n3 = b2.currentPc();
        b2.addAstore(n2);
        if (rtype.isPrimitive()) {
            char c2 = ((CtPrimitiveType)rtype).getDescriptor();
            if (c2 == 'D') {
                b2.addDconst(0.0);
                b2.addDstore(returnVarNo);
            } else if (c2 == 'F') {
                b2.addFconst(0.0f);
                b2.addFstore(returnVarNo);
            } else if (c2 == 'J') {
                b2.addLconst(0L);
                b2.addLstore(returnVarNo);
            } else if (c2 == 'V') {
                b2.addOpcode(1);
                b2.addAstore(returnVarNo);
            } else {
                b2.addIconst(0);
                b2.addIstore(returnVarNo);
            }
        } else {
            b2.addOpcode(1);
            b2.addAstore(returnVarNo);
        }
        javac.compileStmnt(src);
        b2.addAload(n2);
        b2.addOpcode(191);
        return b2.currentPc() - n3;
    }

    public void addCatch(String src, CtClass exceptionType) throws CannotCompileException {
        this.addCatch(src, exceptionType, "$e");
    }

    public void addCatch(String src, CtClass exceptionType, String exceptionName) throws CannotCompileException {
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        ConstPool constPool = this.methodInfo.getConstPool();
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        Bytecode bytecode = new Bytecode(constPool, codeAttribute.getMaxStack(), codeAttribute.getMaxLocals());
        bytecode.setStackDepth(1);
        Javac javac = new Javac(bytecode, ctClass);
        try {
            javac.recordParams(this.getParameterTypes(), Modifier.isStatic(this.getModifiers()));
            int n2 = javac.recordVariable(exceptionType, exceptionName);
            bytecode.addAstore(n2);
            javac.compileStmnt(src);
            int n3 = bytecode.getMaxStack();
            int n4 = bytecode.getMaxLocals();
            if (n3 > codeAttribute.getMaxStack()) {
                codeAttribute.setMaxStack(n3);
            }
            if (n4 > codeAttribute.getMaxLocals()) {
                codeAttribute.setMaxLocals(n4);
            }
            int n5 = codeIterator.getCodeLength();
            int n6 = codeIterator.append(bytecode.get());
            int n7 = n5;
            codeAttribute.getExceptionTable().add(this.getStartPosOfBody(codeAttribute), n7, n7, constPool.addClassInfo(exceptionType));
            codeIterator.append(bytecode.getExceptionTable(), n6);
            this.methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    int getStartPosOfBody(CodeAttribute ca) throws CannotCompileException {
        return 0;
    }

    public int insertAt(int lineNum, String src) throws CannotCompileException {
        return this.insertAt(lineNum, true, src);
    }

    public int insertAt(int lineNum, boolean modify, String src) throws CannotCompileException {
        CodeAttribute codeAttribute = this.methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            throw new CannotCompileException("no method body");
        }
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)codeAttribute.getAttribute("LineNumberTable");
        if (lineNumberAttribute == null) {
            throw new CannotCompileException("no line number info");
        }
        LineNumberAttribute.Pc pc = lineNumberAttribute.toNearPc(lineNum);
        lineNum = pc.line;
        int n2 = pc.index;
        if (!modify) {
            return lineNum;
        }
        CtClass ctClass = this.declaringClass;
        ctClass.checkModify();
        CodeIterator codeIterator = codeAttribute.iterator();
        Javac javac = new Javac(ctClass);
        try {
            javac.recordLocalVariables(codeAttribute, n2);
            javac.recordParams(this.getParameterTypes(), Modifier.isStatic(this.getModifiers()));
            javac.setMaxLocals(codeAttribute.getMaxLocals());
            javac.compileStmnt(src);
            Bytecode bytecode = javac.getBytecode();
            int n3 = bytecode.getMaxLocals();
            int n4 = bytecode.getMaxStack();
            codeAttribute.setMaxLocals(n3);
            if (n4 > codeAttribute.getMaxStack()) {
                codeAttribute.setMaxStack(n4);
            }
            n2 = codeIterator.insertAt(n2, bytecode.get());
            codeIterator.insert(bytecode.getExceptionTable(), n2);
            this.methodInfo.rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return lineNum;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }
}

