/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtClassType;
import ai.h2o.javassist.Modifier;

public abstract class CtMember {
    CtMember next;
    protected CtClass declaringClass;

    protected CtMember(CtClass clazz) {
        this.declaringClass = clazz;
        this.next = null;
    }

    final CtMember next() {
        return this.next;
    }

    void nameReplaced() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        stringBuffer.append(Modifier.toString(this.getModifiers()));
        this.extendToString(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected abstract void extendToString(StringBuffer var1);

    public CtClass getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean visibleFrom(CtClass clazz) {
        int n2 = this.getModifiers();
        if (Modifier.isPublic(n2)) {
            return true;
        }
        if (Modifier.isPrivate(n2)) {
            return clazz == this.declaringClass;
        }
        String string = this.declaringClass.getPackageName();
        String string2 = clazz.getPackageName();
        boolean bl = string == null ? string2 == null : string.equals(string2);
        if (!bl && Modifier.isProtected(n2)) {
            return clazz.subclassOf(this.declaringClass);
        }
        return bl;
    }

    public abstract int getModifiers();

    public abstract void setModifiers(int var1);

    public boolean hasAnnotation(Class<?> clz) {
        return this.hasAnnotation(clz.getName());
    }

    public abstract boolean hasAnnotation(String var1);

    public abstract Object getAnnotation(Class<?> var1) throws ClassNotFoundException;

    public abstract Object[] getAnnotations() throws ClassNotFoundException;

    public abstract Object[] getAvailableAnnotations();

    public abstract String getName();

    public abstract String getSignature();

    public abstract String getGenericSignature();

    public abstract void setGenericSignature(String var1);

    public abstract byte[] getAttribute(String var1);

    public abstract void setAttribute(String var1, byte[] var2);

    static class Cache
    extends CtMember {
        private CtMember methodTail = this;
        private CtMember consTail = this;
        private CtMember fieldTail = this;

        @Override
        protected void extendToString(StringBuffer buffer) {
        }

        @Override
        public boolean hasAnnotation(String clz) {
            return false;
        }

        @Override
        public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
            return null;
        }

        @Override
        public Object[] getAnnotations() throws ClassNotFoundException {
            return null;
        }

        @Override
        public byte[] getAttribute(String name) {
            return null;
        }

        @Override
        public Object[] getAvailableAnnotations() {
            return null;
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getSignature() {
            return null;
        }

        @Override
        public void setAttribute(String name, byte[] data) {
        }

        @Override
        public void setModifiers(int mod) {
        }

        @Override
        public String getGenericSignature() {
            return null;
        }

        @Override
        public void setGenericSignature(String sig) {
        }

        Cache(CtClassType decl) {
            super(decl);
            this.fieldTail.next = this;
        }

        CtMember methodHead() {
            return this;
        }

        CtMember lastMethod() {
            return this.methodTail;
        }

        CtMember consHead() {
            return this.methodTail;
        }

        CtMember lastCons() {
            return this.consTail;
        }

        CtMember fieldHead() {
            return this.consTail;
        }

        CtMember lastField() {
            return this.fieldTail;
        }

        void addMethod(CtMember method) {
            method.next = this.methodTail.next;
            this.methodTail.next = method;
            if (this.methodTail == this.consTail) {
                this.consTail = method;
                if (this.methodTail == this.fieldTail) {
                    this.fieldTail = method;
                }
            }
            this.methodTail = method;
        }

        void addConstructor(CtMember cons) {
            cons.next = this.consTail.next;
            this.consTail.next = cons;
            if (this.consTail == this.fieldTail) {
                this.fieldTail = cons;
            }
            this.consTail = cons;
        }

        void addField(CtMember field) {
            field.next = this;
            this.fieldTail.next = field;
            this.fieldTail = field;
        }

        static int count(CtMember head, CtMember tail) {
            int n2 = 0;
            while (head != tail) {
                ++n2;
                head = head.next;
            }
            return n2;
        }

        void remove(CtMember mem) {
            CtMember ctMember;
            CtMember ctMember2 = this;
            while ((ctMember = ctMember2.next) != this) {
                if (ctMember == mem) {
                    ctMember2.next = ctMember.next;
                    if (ctMember == this.methodTail) {
                        this.methodTail = ctMember2;
                    }
                    if (ctMember == this.consTail) {
                        this.consTail = ctMember2;
                    }
                    if (ctMember != this.fieldTail) break;
                    this.fieldTail = ctMember2;
                    return;
                }
                ctMember2 = ctMember2.next;
            }
        }
    }
}

