/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AnnotationDefaultAttribute;
import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.BootstrapMethodsAttribute;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ConstantAttribute;
import ai.h2o.javassist.bytecode.DeprecatedAttribute;
import ai.h2o.javassist.bytecode.EnclosingMethodAttribute;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.InnerClassesAttribute;
import ai.h2o.javassist.bytecode.LineNumberAttribute;
import ai.h2o.javassist.bytecode.LocalVariableAttribute;
import ai.h2o.javassist.bytecode.LocalVariableTypeAttribute;
import ai.h2o.javassist.bytecode.MethodParametersAttribute;
import ai.h2o.javassist.bytecode.NestHostAttribute;
import ai.h2o.javassist.bytecode.NestMembersAttribute;
import ai.h2o.javassist.bytecode.ParameterAnnotationsAttribute;
import ai.h2o.javassist.bytecode.SignatureAttribute;
import ai.h2o.javassist.bytecode.SourceFileAttribute;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import ai.h2o.javassist.bytecode.SyntheticAttribute;
import ai.h2o.javassist.bytecode.TypeAnnotationsAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool cp, int attrname, byte[] attrinfo) {
        this.constPool = cp;
        this.name = attrname;
        this.info = attrinfo;
    }

    protected AttributeInfo(ConstPool cp, String attrname) {
        this(cp, attrname, null);
    }

    public AttributeInfo(ConstPool cp, String attrname, byte[] attrinfo) {
        ConstPool constPool = cp;
        this(constPool, constPool.addUtf8Info(attrname), attrinfo);
    }

    protected AttributeInfo(ConstPool cp, int n2, DataInputStream in) throws IOException {
        this.constPool = cp;
        this.name = n2;
        int n3 = in.readInt();
        this.info = new byte[n3];
        if (n3 > 0) {
            in.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool cp, DataInputStream in) throws IOException {
        int n2 = in.readUnsignedShort();
        String string = cp.getUtf8Info(n2);
        char c2 = string.charAt(0);
        if (c2 < 'E') {
            if (string.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(cp, n2, in);
            }
            if (string.equals("BootstrapMethods")) {
                return new BootstrapMethodsAttribute(cp, n2, in);
            }
            if (string.equals("Code")) {
                return new CodeAttribute(cp, n2, in);
            }
            if (string.equals("ConstantValue")) {
                return new ConstantAttribute(cp, n2, in);
            }
            if (string.equals("Deprecated")) {
                return new DeprecatedAttribute(cp, n2, in);
            }
        }
        if (c2 < 'M') {
            if (string.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(cp, n2, in);
            }
            if (string.equals("Exceptions")) {
                return new ExceptionsAttribute(cp, n2, in);
            }
            if (string.equals("InnerClasses")) {
                return new InnerClassesAttribute(cp, n2, in);
            }
            if (string.equals("LineNumberTable")) {
                return new LineNumberAttribute(cp, n2, in);
            }
            if (string.equals("LocalVariableTable")) {
                return new LocalVariableAttribute(cp, n2, in);
            }
            if (string.equals("LocalVariableTypeTable")) {
                return new LocalVariableTypeAttribute(cp, n2, in);
            }
        }
        if (c2 < 'S') {
            if (string.equals("MethodParameters")) {
                return new MethodParametersAttribute(cp, n2, in);
            }
            if (string.equals("NestHost")) {
                return new NestHostAttribute(cp, n2, in);
            }
            if (string.equals("NestMembers")) {
                return new NestMembersAttribute(cp, n2, in);
            }
            if (string.equals("RuntimeVisibleAnnotations") || string.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(cp, n2, in);
            }
            if (string.equals("RuntimeVisibleParameterAnnotations") || string.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(cp, n2, in);
            }
            if (string.equals("RuntimeVisibleTypeAnnotations") || string.equals("RuntimeInvisibleTypeAnnotations")) {
                return new TypeAnnotationsAttribute(cp, n2, in);
            }
        }
        if (c2 >= 'S') {
            if (string.equals("Signature")) {
                return new SignatureAttribute(cp, n2, in);
            }
            if (string.equals("SourceFile")) {
                return new SourceFileAttribute(cp, n2, in);
            }
            if (string.equals("Synthetic")) {
                return new SyntheticAttribute(cp, n2, in);
            }
            if (string.equals("StackMap")) {
                return new StackMap(cp, n2, in);
            }
            if (string.equals("StackMapTable")) {
                return new StackMapTable(cp, n2, in);
            }
        }
        return new AttributeInfo(cp, n2, in);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] newinfo) {
        this.info = newinfo;
    }

    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        return new AttributeInfo(newCp, this.getName(), Arrays.copyOf(this.info, this.info.length));
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.info.length);
        if (this.info.length > 0) {
            out.write(this.info);
        }
    }

    static int getLength(List<AttributeInfo> attributes) {
        int n2 = 0;
        for (AttributeInfo attributeInfo : attributes) {
            n2 += attributeInfo.length();
        }
        return n2;
    }

    static AttributeInfo lookup(List<AttributeInfo> attributes, String name) {
        if (attributes == null) {
            return null;
        }
        for (AttributeInfo attributeInfo : attributes) {
            if (!attributeInfo.getName().equals(name)) continue;
            return attributeInfo;
        }
        return null;
    }

    static synchronized AttributeInfo remove(List<AttributeInfo> attributes, String name) {
        if (attributes == null) {
            return null;
        }
        for (AttributeInfo attributeInfo : attributes) {
            if (!attributeInfo.getName().equals(name) || !attributes.remove(attributeInfo)) continue;
            return attributeInfo;
        }
        return null;
    }

    static void writeAll(List<AttributeInfo> attributes, DataOutputStream out) throws IOException {
        if (attributes == null) {
            return;
        }
        for (AttributeInfo attributeInfo : attributes) {
            attributeInfo.write(out);
        }
    }

    static List<AttributeInfo> copyAll(List<AttributeInfo> attributes, ConstPool cp) {
        if (attributes == null) {
            return null;
        }
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>();
        for (AttributeInfo attributeInfo : attributes) {
            arrayList.add(attributeInfo.copy(cp, null));
        }
        return arrayList;
    }

    void renameClass(String oldname, String newname) {
    }

    void renameClass(Map<String, String> classnames) {
    }

    static void renameClass(List<AttributeInfo> attributes, String oldname, String newname) {
        if (attributes == null) {
            return;
        }
        for (AttributeInfo attributeInfo : attributes) {
            attributeInfo.renameClass(oldname, newname);
        }
    }

    static void renameClass(List<AttributeInfo> attributes, Map<String, String> classnames) {
        if (attributes == null) {
            return;
        }
        for (AttributeInfo attributeInfo : attributes) {
            attributeInfo.renameClass(classnames);
        }
    }

    void getRefClasses(Map<String, String> classnames) {
    }

    static void getRefClasses(List<AttributeInfo> attributes, Map<String, String> classnames) {
        if (attributes == null) {
            return;
        }
        for (AttributeInfo attributeInfo : attributes) {
            attributeInfo.getRefClasses(classnames);
        }
    }
}

