/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ExceptionTableEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExceptionTable
implements Cloneable {
    private ConstPool constPool;
    private List<ExceptionTableEntry> entries;

    public ExceptionTable(ConstPool cp) {
        this.constPool = cp;
        this.entries = new ArrayList<ExceptionTableEntry>();
    }

    ExceptionTable(ConstPool cp, DataInputStream in) throws IOException {
        this.constPool = cp;
        int n2 = in.readUnsignedShort();
        ArrayList<ExceptionTableEntry> arrayList = new ArrayList<ExceptionTableEntry>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = in.readUnsignedShort();
            int n4 = in.readUnsignedShort();
            int n5 = in.readUnsignedShort();
            int n6 = in.readUnsignedShort();
            arrayList.add(new ExceptionTableEntry(n3, n4, n5, n6));
        }
        this.entries = arrayList;
    }

    public Object clone() throws CloneNotSupportedException {
        ExceptionTable exceptionTable = (ExceptionTable)super.clone();
        ((ExceptionTable)super.clone()).entries = new ArrayList<ExceptionTableEntry>(this.entries);
        return exceptionTable;
    }

    public int size() {
        return this.entries.size();
    }

    public int startPc(int nth) {
        return this.entries.get((int)nth).startPc;
    }

    public void setStartPc(int nth, int value) {
        this.entries.get((int)nth).startPc = value;
    }

    public int endPc(int nth) {
        return this.entries.get((int)nth).endPc;
    }

    public void setEndPc(int nth, int value) {
        this.entries.get((int)nth).endPc = value;
    }

    public int handlerPc(int nth) {
        return this.entries.get((int)nth).handlerPc;
    }

    public void setHandlerPc(int nth, int value) {
        this.entries.get((int)nth).handlerPc = value;
    }

    public int catchType(int nth) {
        return this.entries.get((int)nth).catchType;
    }

    public void setCatchType(int nth, int value) {
        this.entries.get((int)nth).catchType = value;
    }

    public void add(int index, ExceptionTable table, int offset) {
        int n2 = table.size();
        while (--n2 >= 0) {
            ExceptionTableEntry exceptionTableEntry = table.entries.get(n2);
            this.add(index, exceptionTableEntry.startPc + offset, exceptionTableEntry.endPc + offset, exceptionTableEntry.handlerPc + offset, exceptionTableEntry.catchType);
        }
    }

    public void add(int index, int start, int end, int handler, int type) {
        if (start < end) {
            this.entries.add(index, new ExceptionTableEntry(start, end, handler, type));
        }
    }

    public void add(int start, int end, int handler, int type) {
        if (start < end) {
            this.entries.add(new ExceptionTableEntry(start, end, handler, type));
        }
    }

    public void remove(int index) {
        this.entries.remove(index);
    }

    public ExceptionTable copy(ConstPool newCp, Map<String, String> classnames) {
        ExceptionTable exceptionTable = new ExceptionTable(newCp);
        ConstPool constPool = this.constPool;
        for (ExceptionTableEntry exceptionTableEntry : this.entries) {
            int n2 = constPool.copy(exceptionTableEntry.catchType, newCp, classnames);
            exceptionTable.add(exceptionTableEntry.startPc, exceptionTableEntry.endPc, exceptionTableEntry.handlerPc, n2);
        }
        return exceptionTable;
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        for (ExceptionTableEntry exceptionTableEntry : this.entries) {
            var4_4.next().startPc = ExceptionTable.shiftPc(exceptionTableEntry.startPc, where, gapLength, exclusive);
            exceptionTableEntry.endPc = ExceptionTable.shiftPc(exceptionTableEntry.endPc, where, gapLength, exclusive);
            exceptionTableEntry.handlerPc = ExceptionTable.shiftPc(exceptionTableEntry.handlerPc, where, gapLength, exclusive);
        }
    }

    private static int shiftPc(int pc, int where, int gapLength, boolean exclusive) {
        if (pc > where || exclusive && pc == where) {
            pc += gapLength;
        }
        return pc;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.size());
        for (ExceptionTableEntry exceptionTableEntry : this.entries) {
            out.writeShort(exceptionTableEntry.startPc);
            out.writeShort(exceptionTableEntry.endPc);
            out.writeShort(exceptionTableEntry.handlerPc);
            out.writeShort(exceptionTableEntry.catchType);
        }
    }
}

