/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class LocalVariableAttribute
extends AttributeInfo {
    public static final String tag = "LocalVariableTable";
    public static final String typeTag = "LocalVariableTypeTable";

    public LocalVariableAttribute(ConstPool cp) {
        super(cp, tag, new byte[2]);
        ByteArray.write16bit(0, this.info, 0);
    }

    @Deprecated
    public LocalVariableAttribute(ConstPool cp, String name) {
        super(cp, name, new byte[2]);
        ByteArray.write16bit(0, this.info, 0);
    }

    LocalVariableAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    LocalVariableAttribute(ConstPool cp, String name, byte[] i2) {
        super(cp, name, i2);
    }

    public void addEntry(int startPc, int length, int nameIndex, int descriptorIndex, int index) {
        int n2 = this.info.length;
        byte[] byArray = new byte[n2 + 10];
        ByteArray.write16bit(this.tableLength() + 1, byArray, 0);
        for (int i2 = 2; i2 < n2; ++i2) {
            byArray[i2] = this.info[i2];
        }
        ByteArray.write16bit(startPc, byArray, n2);
        ByteArray.write16bit(length, byArray, n2 + 2);
        ByteArray.write16bit(nameIndex, byArray, n2 + 4);
        ByteArray.write16bit(descriptorIndex, byArray, n2 + 6);
        ByteArray.write16bit(index, byArray, n2 + 8);
        this.info = byArray;
    }

    @Override
    void renameClass(String oldname, String newname) {
        ConstPool constPool = this.getConstPool();
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 10 + 2;
            int n4 = ByteArray.readU16bit(this.info, n3 + 6);
            if (n4 == 0) continue;
            String string = constPool.getUtf8Info(n4);
            string = this.renameEntry(string, oldname, newname);
            ByteArray.write16bit(constPool.addUtf8Info(string), this.info, n3 + 6);
        }
    }

    String renameEntry(String desc, String oldname, String newname) {
        return Descriptor.rename(desc, oldname, newname);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        ConstPool constPool = this.getConstPool();
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 10 + 2;
            int n4 = ByteArray.readU16bit(this.info, n3 + 6);
            if (n4 == 0) continue;
            String string = constPool.getUtf8Info(n4);
            string = this.renameEntry(string, classnames);
            ByteArray.write16bit(constPool.addUtf8Info(string), this.info, n3 + 6);
        }
    }

    String renameEntry(String desc, Map<String, String> classnames) {
        return Descriptor.rename(desc, classnames);
    }

    public void shiftIndex(int lessThan, int delta) {
        int n2 = this.info.length;
        for (int i2 = 2; i2 < n2; i2 += 10) {
            int n3 = ByteArray.readU16bit(this.info, i2 + 8);
            if (n3 < lessThan) continue;
            ByteArray.write16bit(n3 + delta, this.info, i2 + 8);
        }
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public int startPc(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 2);
    }

    public int codeLength(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 4);
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 10 + 2;
            int n4 = ByteArray.readU16bit(this.info, n3);
            int n5 = ByteArray.readU16bit(this.info, n3 + 2);
            if (n4 > where || exclusive && n4 == where && n4 != 0) {
                ByteArray.write16bit(n4 + gapLength, this.info, n3);
                continue;
            }
            if (n4 + n5 <= where && (!exclusive || n4 + n5 != where)) continue;
            ByteArray.write16bit(n5 + gapLength, this.info, n3 + 2);
        }
    }

    public int nameIndex(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 6);
    }

    public String variableName(int i2) {
        return this.getConstPool().getUtf8Info(this.nameIndex(i2));
    }

    public int descriptorIndex(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 8);
    }

    public int signatureIndex(int i2) {
        return this.descriptorIndex(i2);
    }

    public String descriptor(int i2) {
        return this.getConstPool().getUtf8Info(this.descriptorIndex(i2));
    }

    public String signature(int i2) {
        return this.descriptor(i2);
    }

    public int index(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 10);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        byte[] byArray = this.get();
        byte[] byArray2 = new byte[byArray.length];
        ConstPool constPool = this.getConstPool();
        LocalVariableAttribute localVariableAttribute = this.makeThisAttr(newCp, byArray2);
        int n2 = ByteArray.readU16bit(byArray, 0);
        ByteArray.write16bit(n2, byArray2, 0);
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = ByteArray.readU16bit(byArray, n3);
            int n5 = ByteArray.readU16bit(byArray, n3 + 2);
            int n6 = ByteArray.readU16bit(byArray, n3 + 4);
            int n7 = ByteArray.readU16bit(byArray, n3 + 6);
            int n8 = ByteArray.readU16bit(byArray, n3 + 8);
            ByteArray.write16bit(n4, byArray2, n3);
            ByteArray.write16bit(n5, byArray2, n3 + 2);
            if (n6 != 0) {
                n6 = constPool.copy(n6, newCp, null);
            }
            ByteArray.write16bit(n6, byArray2, n3 + 4);
            if (n7 != 0) {
                String string = constPool.getUtf8Info(n7);
                string = Descriptor.rename(string, classnames);
                n7 = newCp.addUtf8Info(string);
            }
            ByteArray.write16bit(n7, byArray2, n3 + 6);
            ByteArray.write16bit(n8, byArray2, n3 + 8);
            n3 += 10;
        }
        return localVariableAttribute;
    }

    LocalVariableAttribute makeThisAttr(ConstPool cp, byte[] dest) {
        return new LocalVariableAttribute(cp, tag, dest);
    }
}

