/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.ConstInfo;

final class LongVector {
    static final int ASIZE = 128;
    static final int ABITS = 7;
    static final int VSIZE = 8;
    private ConstInfo[][] objects;
    private int elements;

    public LongVector() {
        this.objects = new ConstInfo[8][];
        this.elements = 0;
    }

    public LongVector(int initialSize) {
        int n2 = (initialSize >> 7 & 0xFFFFFFF8) + 8;
        this.objects = new ConstInfo[n2][];
        this.elements = 0;
    }

    public final int size() {
        return this.elements;
    }

    public final int capacity() {
        return this.objects.length << 7;
    }

    public final ConstInfo elementAt(int i2) {
        if (i2 < 0 || this.elements <= i2) {
            return null;
        }
        return this.objects[i2 >> 7][i2 & 0x7F];
    }

    public final void addElement(ConstInfo value) {
        int n2 = this.elements >> 7;
        int n3 = this.elements & 0x7F;
        int n4 = this.objects.length;
        if (n2 >= n4) {
            ConstInfo[][] constInfoArrayArray = new ConstInfo[n4 + 8][];
            System.arraycopy(this.objects, 0, constInfoArrayArray, 0, n4);
            this.objects = constInfoArrayArray;
        }
        if (this.objects[n2] == null) {
            this.objects[n2] = new ConstInfo[128];
        }
        this.objects[n2][n3] = value;
        ++this.elements;
    }
}

