/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.annotation;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.annotation.AnnotationImpl;
import ai.h2o.javassist.bytecode.annotation.AnnotationMemberValue;
import ai.h2o.javassist.bytecode.annotation.AnnotationsWriter;
import ai.h2o.javassist.bytecode.annotation.ArrayMemberValue;
import ai.h2o.javassist.bytecode.annotation.BooleanMemberValue;
import ai.h2o.javassist.bytecode.annotation.ByteMemberValue;
import ai.h2o.javassist.bytecode.annotation.CharMemberValue;
import ai.h2o.javassist.bytecode.annotation.ClassMemberValue;
import ai.h2o.javassist.bytecode.annotation.DoubleMemberValue;
import ai.h2o.javassist.bytecode.annotation.EnumMemberValue;
import ai.h2o.javassist.bytecode.annotation.FloatMemberValue;
import ai.h2o.javassist.bytecode.annotation.IntegerMemberValue;
import ai.h2o.javassist.bytecode.annotation.LongMemberValue;
import ai.h2o.javassist.bytecode.annotation.MemberValue;
import ai.h2o.javassist.bytecode.annotation.NoSuchClassError;
import ai.h2o.javassist.bytecode.annotation.ShortMemberValue;
import ai.h2o.javassist.bytecode.annotation.StringMemberValue;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    Map<String, Pair> members;

    public Annotation(int type, ConstPool cp) {
        this.pool = cp;
        this.typeIndex = type;
        this.members = null;
    }

    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of(typeName)), cp);
    }

    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
        if (ctMethodArray.length > 0) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        CtMethod[] ctMethodArray2 = ctMethodArray;
        int n2 = ctMethodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CtMethod ctMethod = ctMethodArray2[i2];
            this.addMemberValue(ctMethod.getName(), Annotation.createMemberValue(cp, ctMethod.getReturnType()));
        }
    }

    public static MemberValue createMemberValue(ConstPool cp, CtClass type) throws NotFoundException {
        if (type == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (type == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (type == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (type == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (type == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (type == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (type == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (type == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (type.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (type.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (type.isArray()) {
            CtClass ctClass = type.getComponentType();
            MemberValue memberValue = Annotation.createMemberValue(cp, ctClass);
            return new ArrayMemberValue(memberValue, cp);
        }
        if (type.isInterface()) {
            Annotation annotation = new Annotation(cp, type);
            return new AnnotationMemberValue(annotation, cp);
        }
        EnumMemberValue enumMemberValue = new EnumMemberValue(cp);
        enumMemberValue.setType(type.getName());
        return enumMemberValue;
    }

    public void addMemberValue(int nameIndex, MemberValue value) {
        Pair pair = new Pair();
        new Pair().name = nameIndex;
        pair.value = value;
        this.addMemberValue(pair);
    }

    public void addMemberValue(String name, MemberValue value) {
        Pair pair = new Pair();
        new Pair().name = this.pool.addUtf8Info(name);
        pair.value = value;
        if (this.members == null) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        this.members.put(name, pair);
    }

    private void addMemberValue(Pair pair) {
        String string = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        this.members.put(string, pair);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@");
        stringBuffer.append(this.getTypeName());
        if (this.members != null) {
            stringBuffer.append("(");
            for (String string : this.members.keySet()) {
                stringBuffer.append(string).append("=").append(this.getMemberValue(string)).append(", ");
            }
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.setLength(stringBuffer2.length() - 2);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set<String> getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String name) {
        if (this.members == null || this.members.get(name) == null) {
            return null;
        }
        return this.members.get((Object)name).value;
    }

    public Object toAnnotationType(ClassLoader cl, ClassPool cp) throws ClassNotFoundException, NoSuchClassError {
        Class<?> clazz = MemberValue.loadClass(cl, this.getTypeName());
        try {
            return AnnotationImpl.make(cl, clazz, cp, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(clazz.getName(), illegalArgumentException);
        }
        catch (IllegalAccessError illegalAccessError) {
            throw new ClassNotFoundException(clazz.getName(), illegalAccessError);
        }
    }

    public void write(AnnotationsWriter writer) throws IOException {
        String string = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            writer.annotation(string, 0);
            return;
        }
        writer.annotation(string, this.members.size());
        for (Pair pair : this.members.values()) {
            writer.memberValuePair(pair.name);
            pair.value.write(writer);
        }
    }

    public int hashCode() {
        return this.getTypeName().hashCode() + (this.members == null ? 0 : this.members.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Annotation)) {
            return false;
        }
        Annotation annotation = (Annotation)obj;
        if (!this.getTypeName().equals(annotation.getTypeName())) {
            return false;
        }
        Map<String, Pair> map = annotation.members;
        if (this.members == map) {
            return true;
        }
        if (this.members == null) {
            return map == null;
        }
        if (map == null) {
            return false;
        }
        return this.members.equals(map);
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

