/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.stackmap;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import ai.h2o.javassist.bytecode.stackmap.BasicBlock;
import ai.h2o.javassist.bytecode.stackmap.Tracer;
import ai.h2o.javassist.bytecode.stackmap.TypeData;
import ai.h2o.javassist.bytecode.stackmap.TypedBlock;
import java.util.ArrayList;

public class MapMaker
extends Tracer {
    public static StackMapTable make(ClassPool classes, MethodInfo minfo) throws BadBytecode {
        TypedBlock[] typedBlockArray;
        CodeAttribute codeAttribute = minfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        try {
            typedBlockArray = TypedBlock.makeBlocks(minfo, codeAttribute, true);
        }
        catch (BasicBlock.JsrBytecode jsrBytecode) {
            return null;
        }
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classes, minfo, codeAttribute);
        try {
            mapMaker.make(typedBlockArray, codeAttribute.getCode());
        }
        catch (BadBytecode badBytecode) {
            throw new BadBytecode(minfo, (Throwable)badBytecode);
        }
        return mapMaker.toStackMap(typedBlockArray);
    }

    public static StackMap make2(ClassPool classes, MethodInfo minfo) throws BadBytecode {
        TypedBlock[] typedBlockArray;
        CodeAttribute codeAttribute = minfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        try {
            typedBlockArray = TypedBlock.makeBlocks(minfo, codeAttribute, true);
        }
        catch (BasicBlock.JsrBytecode jsrBytecode) {
            return null;
        }
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classes, minfo, codeAttribute);
        try {
            mapMaker.make(typedBlockArray, codeAttribute.getCode());
        }
        catch (BadBytecode badBytecode) {
            throw new BadBytecode(minfo, (Throwable)badBytecode);
        }
        return mapMaker.toStackMap2(minfo.getConstPool(), typedBlockArray);
    }

    public MapMaker(ClassPool classes, MethodInfo minfo, CodeAttribute ca) {
        super(classes, minfo.getConstPool(), ca.getMaxStack(), ca.getMaxLocals(), TypedBlock.getRetType(minfo.getDescriptor()));
    }

    protected MapMaker(MapMaker old) {
        super(old);
    }

    void make(TypedBlock[] blocks, byte[] code) throws BadBytecode {
        this.make(code, blocks[0]);
        this.findDeadCatchers(code, blocks);
        try {
            this.fixTypes(code, blocks);
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("failed to resolve types", (Throwable)notFoundException);
        }
    }

    private void make(byte[] code, TypedBlock tb) throws BadBytecode {
        int n2;
        MapMaker.copyTypeData(tb.stackTop, tb.stackTypes, this.stackTypes);
        this.stackTop = tb.stackTop;
        MapMaker.copyTypeData(tb.localsTypes.length, tb.localsTypes, this.localsTypes);
        this.traceException(code, tb.toCatch);
        int n3 = n2 + tb.length;
        for (n2 = tb.position; n2 < n3; n2 += this.doOpcode(n2, code)) {
            this.traceException(code, tb.toCatch);
        }
        if (tb.exit != null) {
            for (int i2 = 0; i2 < tb.exit.length; ++i2) {
                TypedBlock typedBlock = (TypedBlock)tb.exit[i2];
                if (typedBlock.alreadySet()) {
                    this.mergeMap(typedBlock, true);
                    continue;
                }
                this.recordStackMap(typedBlock);
                MapMaker mapMaker = new MapMaker(this);
                mapMaker.make(code, typedBlock);
            }
        }
    }

    private void traceException(byte[] code, BasicBlock.Catch handler) throws BadBytecode {
        while (handler != null) {
            TypedBlock typedBlock = (TypedBlock)handler.body;
            if (typedBlock.alreadySet()) {
                this.mergeMap(typedBlock, false);
                if (typedBlock.stackTop <= 0) {
                    throw new BadBytecode("bad catch clause: " + handler.typeIndex);
                }
                MapMaker mapMaker = this;
                typedBlock.stackTypes[0] = mapMaker.merge(mapMaker.toExceptionType(handler.typeIndex), typedBlock.stackTypes[0]);
            } else {
                this.recordStackMap(typedBlock, handler.typeIndex);
                MapMaker mapMaker = new MapMaker(this);
                mapMaker.make(code, typedBlock);
            }
            handler = handler.next;
        }
    }

    private void mergeMap(TypedBlock dest, boolean mergeStack) throws BadBytecode {
        int n2;
        int n3 = this.localsTypes.length;
        for (n2 = 0; n2 < n3; ++n2) {
            MapMaker mapMaker = this;
            dest.localsTypes[n2] = mapMaker.merge(MapMaker.validateTypeData(mapMaker.localsTypes, n3, n2), dest.localsTypes[n2]);
        }
        if (mergeStack) {
            n3 = this.stackTop;
            for (n2 = 0; n2 < n3; ++n2) {
                MapMaker mapMaker = this;
                dest.stackTypes[n2] = mapMaker.merge(mapMaker.stackTypes[n2], dest.stackTypes[n2]);
            }
        }
    }

    private TypeData merge(TypeData src, TypeData target) throws BadBytecode {
        if (src == target) {
            return target;
        }
        if (target instanceof TypeData.ClassName || target instanceof TypeData.BasicType) {
            return target;
        }
        if (target instanceof TypeData.AbsTypeVar) {
            ((TypeData.AbsTypeVar)target).merge(src);
            return target;
        }
        throw new RuntimeException("fatal: this should never happen");
    }

    private void recordStackMap(TypedBlock target) throws BadBytecode {
        TypeData[] typeDataArray = TypeData.make(this.stackTypes.length);
        int n2 = this.stackTop;
        MapMaker.recordTypeData(n2, this.stackTypes, typeDataArray);
        this.recordStackMap0(target, n2, typeDataArray);
    }

    private void recordStackMap(TypedBlock target, int exceptionType) throws BadBytecode {
        TypeData[] typeDataArray = TypeData.make(this.stackTypes.length);
        TypeData[] typeDataArray2 = typeDataArray;
        typeDataArray[0] = this.toExceptionType(exceptionType).join();
        this.recordStackMap0(target, 1, typeDataArray2);
    }

    private TypeData.ClassName toExceptionType(int exceptionType) {
        String string = exceptionType == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(exceptionType);
        return new TypeData.ClassName(string);
    }

    private void recordStackMap0(TypedBlock target, int st, TypeData[] tStackTypes) throws BadBytecode {
        int n2 = this.localsTypes.length;
        TypeData[] typeDataArray = TypeData.make(n2);
        int n3 = MapMaker.recordTypeData(n2, this.localsTypes, typeDataArray);
        target.setStackMap(st, tStackTypes, n3, typeDataArray);
    }

    protected static int recordTypeData(int n2, TypeData[] srcTypes, TypeData[] destTypes) {
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = MapMaker.validateTypeData(srcTypes, n2, i2);
            destTypes[i2] = typeData.join();
            if (typeData == TOP) continue;
            n3 = i2 + 1;
        }
        return n3 + 1;
    }

    protected static void copyTypeData(int n2, TypeData[] srcTypes, TypeData[] destTypes) {
        for (int i2 = 0; i2 < n2; ++i2) {
            destTypes[i2] = srcTypes[i2];
        }
    }

    private static TypeData validateTypeData(TypeData[] data, int length, int index) {
        TypeData typeData = data[index];
        if (typeData.is2WordType() && index + 1 < length && data[index + 1] != TOP) {
            return TOP;
        }
        return typeData;
    }

    private void findDeadCatchers(byte[] code, TypedBlock[] blocks) throws BadBytecode {
        for (TypedBlock typedBlock : blocks) {
            TypedBlock typedBlock2;
            if (typedBlock.alreadySet()) continue;
            this.fixDeadcode(code, typedBlock);
            BasicBlock.Catch catch_ = typedBlock.toCatch;
            if (catch_ == null || (typedBlock2 = (TypedBlock)catch_.body).alreadySet()) continue;
            this.recordStackMap(typedBlock2, catch_.typeIndex);
            this.fixDeadcode(code, typedBlock2);
            typedBlock2.incoming = 1;
        }
    }

    private void fixDeadcode(byte[] code, TypedBlock block) throws BadBytecode {
        int n2 = block.position;
        int n3 = block.length - 3;
        if (n3 < 0) {
            if (n3 == -1) {
                code[n2] = 0;
            }
            code[n2 + block.length - 1] = -65;
            block.incoming = 1;
            this.recordStackMap(block, 0);
            return;
        }
        block.incoming = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            code[n2 + i2] = 0;
        }
        code[n2 + n3] = -89;
        ByteArray.write16bit(-n3, code, n2 + n3 + 1);
    }

    private void fixTypes(byte[] code, TypedBlock[] blocks) throws NotFoundException, BadBytecode {
        ArrayList<TypeData> arrayList = new ArrayList<TypeData>();
        int n2 = blocks.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            TypedBlock typedBlock = blocks[i2];
            if (!typedBlock.alreadySet()) continue;
            int n5 = typedBlock.localsTypes.length;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = typedBlock.localsTypes[n4].dfs(arrayList, n3, this.classPool);
            }
            n5 = typedBlock.stackTop;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = typedBlock.stackTypes[n4].dfs(arrayList, n3, this.classPool);
            }
        }
    }

    public StackMapTable toStackMap(TypedBlock[] blocks) {
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        int n2 = blocks.length;
        TypedBlock typedBlock = blocks[0];
        int n3 = typedBlock.length;
        if (typedBlock.incoming > 0) {
            writer.sameFrame(0);
            --n3;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            TypedBlock typedBlock2 = blocks[i2];
            if (this.isTarget(typedBlock2, blocks[i2 - 1])) {
                typedBlock2.resetNumLocals();
                int n4 = MapMaker.stackMapDiff(typedBlock.numLocals, typedBlock.localsTypes, typedBlock2.numLocals, typedBlock2.localsTypes);
                this.toStackMapBody(writer, typedBlock2, n4, n3, typedBlock);
                n3 = typedBlock2.length - 1;
                typedBlock = typedBlock2;
                continue;
            }
            if (typedBlock2.incoming == 0) {
                writer.sameFrame(n3);
                n3 = typedBlock2.length - 1;
                continue;
            }
            n3 += typedBlock2.length;
        }
        return writer.toStackMapTable(this.cpool);
    }

    private boolean isTarget(TypedBlock cur, TypedBlock prev) {
        int n2 = cur.incoming;
        if (n2 > 1) {
            return true;
        }
        if (n2 <= 0) {
            return false;
        }
        return prev.stop;
    }

    private void toStackMapBody(StackMapTable.Writer writer, TypedBlock bb, int diffL, int offsetDelta, TypedBlock prev) {
        Object object;
        int n2 = bb.stackTop;
        if (n2 == 0) {
            if (diffL == 0) {
                writer.sameFrame(offsetDelta);
                return;
            }
            if (diffL < 0 && diffL >= -3) {
                writer.chopFrame(offsetDelta, -diffL);
                return;
            }
            if (diffL > 0 && diffL <= 3) {
                int[] nArray = new int[diffL];
                int[] nArray2 = this.fillStackMap(bb.numLocals - prev.numLocals, prev.numLocals, nArray, bb.localsTypes);
                writer.appendFrame(offsetDelta, nArray2, nArray);
                return;
            }
        } else {
            if (n2 == 1 && diffL == 0) {
                TypeData typeData = bb.stackTypes[0];
                writer.sameLocals(offsetDelta, typeData.getTypeTag(), typeData.getTypeData(this.cpool));
                return;
            }
            if (n2 == 2 && diffL == 0) {
                TypeData typeData = bb.stackTypes[0];
                object = typeData;
                if (typeData.is2WordType()) {
                    writer.sameLocals(offsetDelta, ((TypeData)object).getTypeTag(), ((TypeData)object).getTypeData(this.cpool));
                    return;
                }
            }
        }
        object = new int[n2];
        int[] nArray = this.fillStackMap(n2, 0, (int[])object, bb.stackTypes);
        int[] nArray3 = new int[bb.numLocals];
        int[] nArray4 = this.fillStackMap(bb.numLocals, 0, nArray3, bb.localsTypes);
        writer.fullFrame(offsetDelta, nArray4, nArray3, nArray, (int[])object);
    }

    private int[] fillStackMap(int num, int offset, int[] data, TypeData[] types) {
        int n2 = offset;
        int n3 = MapMaker.diffSize(types, n2, n2 + num);
        ConstPool constPool = this.cpool;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < num; ++i2) {
            TypeData typeData = types[offset + i2];
            nArray[n4] = typeData.getTypeTag();
            data[n4] = typeData.getTypeData(constPool);
            if (typeData.is2WordType()) {
                ++i2;
            }
            ++n4;
        }
        return nArray;
    }

    private static int stackMapDiff(int oldTdLen, TypeData[] oldTd, int newTdLen, TypeData[] newTd) {
        int n2 = newTdLen - oldTdLen;
        int n3 = n2 > 0 ? oldTdLen : newTdLen;
        if (MapMaker.stackMapEq(oldTd, newTd, n3)) {
            if (n2 > 0) {
                return MapMaker.diffSize(newTd, n3, newTdLen);
            }
            return -MapMaker.diffSize(oldTd, n3, oldTdLen);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] oldTd, TypeData[] newTd, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (oldTd[i2].eq(newTd[i2])) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] types, int offset, int len) {
        int n2 = 0;
        while (offset < len) {
            TypeData typeData = types[offset++];
            ++n2;
            if (!typeData.is2WordType()) continue;
            ++offset;
        }
        return n2;
    }

    public StackMap toStackMap2(ConstPool cp, TypedBlock[] blocks) {
        int n2;
        StackMap.Writer writer = new StackMap.Writer();
        int n3 = blocks.length;
        boolean[] blArray = new boolean[n3];
        TypedBlock typedBlock = blocks[0];
        blArray[0] = typedBlock.incoming > 0;
        int n4 = blArray[0] ? 1 : 0;
        for (n2 = 1; n2 < n3; ++n2) {
            TypedBlock typedBlock2 = blocks[n2];
            blArray[n2] = this.isTarget(typedBlock2, blocks[n2 - 1]);
            if (!blArray[n2]) continue;
            typedBlock2.resetNumLocals();
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        writer.write16bit(n4);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray[n2]) continue;
            this.writeStackFrame(writer, cp, blocks[n2].position, blocks[n2]);
        }
        return writer.toStackMap(cp);
    }

    private void writeStackFrame(StackMap.Writer writer, ConstPool cp, int offset, TypedBlock tb) {
        writer.write16bit(offset);
        this.writeVerifyTypeInfo(writer, cp, tb.localsTypes, tb.numLocals);
        this.writeVerifyTypeInfo(writer, cp, tb.stackTypes, tb.stackTop);
    }

    private void writeVerifyTypeInfo(StackMap.Writer writer, ConstPool cp, TypeData[] types, int num) {
        TypeData typeData;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < num; ++n2) {
            typeData = types[n2];
            if (typeData == null || !typeData.is2WordType()) continue;
            ++n3;
            ++n2;
        }
        writer.write16bit(num - n3);
        for (n2 = 0; n2 < num; ++n2) {
            typeData = types[n2];
            writer.writeVerifyTypeInfo(typeData.getTypeTag(), typeData.getTypeData(cp));
            if (!typeData.is2WordType()) continue;
            ++n2;
        }
    }
}

