/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.convert;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CodeConverter;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.analysis.Analyzer;
import ai.h2o.javassist.bytecode.analysis.Frame;
import ai.h2o.javassist.convert.Transformer;

public final class TransformAccessArrayField
extends Transformer {
    private final String methodClassname;
    private final CodeConverter.ArrayAccessReplacementMethodNames names;
    private Frame[] frames;
    private int offset;

    public TransformAccessArrayField(Transformer next, String methodClassname, CodeConverter.ArrayAccessReplacementMethodNames names) throws NotFoundException {
        super(next);
        this.methodClassname = methodClassname;
        this.names = names;
    }

    @Override
    public final void initialize(ConstPool cp, CtClass clazz, MethodInfo minfo) throws CannotCompileException {
        CodeIterator codeIterator = minfo.getCodeAttribute().iterator();
        while (codeIterator.hasNext()) {
            try {
                int n2 = codeIterator.next();
                int n3 = codeIterator.byteAt(n2);
                if (n3 == 50) {
                    this.initFrames(clazz, minfo);
                }
                if (n3 == 50 || n3 == 51 || n3 == 52 || n3 == 49 || n3 == 48 || n3 == 46 || n3 == 47 || n3 == 53) {
                    this.replace(cp, codeIterator, n2, n3, this.getLoadReplacementSignature(n3));
                    continue;
                }
                if (n3 != 83 && n3 != 84 && n3 != 85 && n3 != 82 && n3 != 81 && n3 != 79 && n3 != 80 && n3 != 86) continue;
                this.replace(cp, codeIterator, n2, n3, this.getStoreReplacementSignature(n3));
            }
            catch (Exception exception) {
                throw new CannotCompileException(exception);
            }
        }
    }

    @Override
    public final void clean() {
        this.frames = null;
        this.offset = -1;
    }

    @Override
    public final int transform(CtClass tclazz, int pos, CodeIterator iterator, ConstPool cp) throws BadBytecode {
        return pos;
    }

    private Frame getFrame(int pos) throws BadBytecode {
        return this.frames[pos - this.offset];
    }

    private void initFrames(CtClass clazz, MethodInfo minfo) throws BadBytecode {
        if (this.frames == null) {
            this.frames = new Analyzer().analyze(clazz, minfo);
            this.offset = 0;
        }
    }

    private int updatePos(int pos, int increment) {
        if (this.offset >= 0) {
            this.offset += increment;
        }
        return pos + increment;
    }

    private String getTopType(int pos) throws BadBytecode {
        Frame frame = this.getFrame(pos);
        if (frame == null) {
            return null;
        }
        CtClass ctClass = frame.peek().getCtClass();
        if (ctClass != null) {
            return Descriptor.toJvmName(ctClass);
        }
        return null;
    }

    private int replace(ConstPool cp, CodeIterator iterator, int pos, int opcode, String signature) throws BadBytecode {
        String string = null;
        String string2 = this.getMethodName(opcode);
        if (string2 != null) {
            if (opcode == 50) {
                string = this.getTopType(iterator.lookAhead());
                if (string == null) {
                    return pos;
                }
                if ("java/lang/Object".equals(string)) {
                    string = null;
                }
            }
            iterator.writeByte(0, pos);
            CodeIterator.Gap gap = iterator.insertGapAt(pos, string != null ? 5 : 2, false);
            pos = gap.position;
            int n2 = cp.addClassInfo(this.methodClassname);
            int n3 = cp.addMethodrefInfo(n2, string2, signature);
            iterator.writeByte(184, pos);
            iterator.write16bit(n3, pos + 1);
            if (string != null) {
                int n4 = cp.addClassInfo(string);
                iterator.writeByte(192, pos + 3);
                iterator.write16bit(n4, pos + 4);
            }
            pos = this.updatePos(pos, gap.length);
        }
        return pos;
    }

    private String getMethodName(int opcode) {
        String string = null;
        switch (opcode) {
            case 50: {
                string = this.names.objectRead();
                break;
            }
            case 51: {
                string = this.names.byteOrBooleanRead();
                break;
            }
            case 52: {
                string = this.names.charRead();
                break;
            }
            case 49: {
                string = this.names.doubleRead();
                break;
            }
            case 48: {
                string = this.names.floatRead();
                break;
            }
            case 46: {
                string = this.names.intRead();
                break;
            }
            case 53: {
                string = this.names.shortRead();
                break;
            }
            case 47: {
                string = this.names.longRead();
                break;
            }
            case 83: {
                string = this.names.objectWrite();
                break;
            }
            case 84: {
                string = this.names.byteOrBooleanWrite();
                break;
            }
            case 85: {
                string = this.names.charWrite();
                break;
            }
            case 82: {
                string = this.names.doubleWrite();
                break;
            }
            case 81: {
                string = this.names.floatWrite();
                break;
            }
            case 79: {
                string = this.names.intWrite();
                break;
            }
            case 86: {
                string = this.names.shortWrite();
                break;
            }
            case 80: {
                string = this.names.longWrite();
            }
        }
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    private String getLoadReplacementSignature(int opcode) throws BadBytecode {
        switch (opcode) {
            case 50: {
                return "(Ljava/lang/Object;I)Ljava/lang/Object;";
            }
            case 51: {
                return "(Ljava/lang/Object;I)B";
            }
            case 52: {
                return "(Ljava/lang/Object;I)C";
            }
            case 49: {
                return "(Ljava/lang/Object;I)D";
            }
            case 48: {
                return "(Ljava/lang/Object;I)F";
            }
            case 46: {
                return "(Ljava/lang/Object;I)I";
            }
            case 53: {
                return "(Ljava/lang/Object;I)S";
            }
            case 47: {
                return "(Ljava/lang/Object;I)J";
            }
        }
        throw new BadBytecode(opcode);
    }

    private String getStoreReplacementSignature(int opcode) throws BadBytecode {
        switch (opcode) {
            case 83: {
                return "(Ljava/lang/Object;ILjava/lang/Object;)V";
            }
            case 84: {
                return "(Ljava/lang/Object;IB)V";
            }
            case 85: {
                return "(Ljava/lang/Object;IC)V";
            }
            case 82: {
                return "(Ljava/lang/Object;ID)V";
            }
            case 81: {
                return "(Ljava/lang/Object;IF)V";
            }
            case 79: {
                return "(Ljava/lang/Object;II)V";
            }
            case 86: {
                return "(Ljava/lang/Object;IS)V";
            }
            case 80: {
                return "(Ljava/lang/Object;IJ)V";
            }
        }
        throw new BadBytecode(opcode);
    }
}

