/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.convert;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.convert.Transformer;

public class TransformReadField
extends Transformer {
    protected String fieldname;
    protected CtClass fieldClass;
    protected boolean isPrivate;
    protected String methodClassname;
    protected String methodName;

    public TransformReadField(Transformer next, CtField field, String methodClassname, String methodName) {
        super(next);
        this.fieldClass = field.getDeclaringClass();
        this.fieldname = field.getName();
        this.methodClassname = methodClassname;
        this.methodName = methodName;
        this.isPrivate = Modifier.isPrivate(field.getModifiers());
    }

    static String isField(ClassPool pool, ConstPool cp, CtClass fclass, String fname, boolean is_private, int index) {
        if (!cp.getFieldrefName(index).equals(fname)) {
            return null;
        }
        try {
            CtClass ctClass = pool.get(cp.getFieldrefClassName(index));
            if (ctClass == fclass || !is_private && TransformReadField.isFieldInSuper(ctClass, fclass, fname)) {
                return cp.getFieldrefType(index);
            }
        }
        catch (NotFoundException notFoundException) {}
        return null;
    }

    static boolean isFieldInSuper(CtClass clazz, CtClass fclass, String fname) {
        if (!clazz.subclassOf(fclass)) {
            return false;
        }
        try {
            CtField ctField = clazz.getField(fname);
            return ctField.getDeclaringClass() == fclass;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    @Override
    public int transform(CtClass tclazz, int pos, CodeIterator iterator, ConstPool cp) throws BadBytecode {
        int n2 = iterator.byteAt(pos);
        if (n2 == 180 || n2 == 178) {
            int n3 = iterator.u16bitAt(pos + 1);
            String string = TransformReadField.isField(tclazz.getClassPool(), cp, this.fieldClass, this.fieldname, this.isPrivate, n3);
            if (string != null) {
                if (n2 == 178) {
                    iterator.move(pos);
                    pos = iterator.insertGap(1);
                    iterator.writeByte(1, pos);
                    pos = iterator.next();
                }
                String string2 = "(Ljava/lang/Object;)" + string;
                int n4 = cp.addClassInfo(this.methodClassname);
                int n5 = cp.addMethodrefInfo(n4, this.methodName, string2);
                iterator.writeByte(184, pos);
                iterator.write16bit(n5, pos + 1);
                return pos;
            }
        }
        return pos;
    }
}

