/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.expr;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;
import ai.h2o.javassist.compiler.JvstCodeGen;
import ai.h2o.javassist.compiler.JvstTypeChecker;
import ai.h2o.javassist.compiler.ProceedHandler;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.expr.Expr;

public class FieldAccess
extends Expr {
    int opcode;

    protected FieldAccess(int pos, CodeIterator i2, CtClass declaring, MethodInfo m2, int op) {
        super(pos, i2, declaring, m2);
        this.opcode = op;
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    public boolean isStatic() {
        return FieldAccess.isStatic(this.opcode);
    }

    static boolean isStatic(int c2) {
        return c2 == 178 || c2 == 179;
    }

    public boolean isReader() {
        return this.opcode == 180 || this.opcode == 178;
    }

    public boolean isWriter() {
        return this.opcode == 181 || this.opcode == 179;
    }

    private CtClass getCtClass() throws NotFoundException {
        return this.thisClass.getClassPool().get(this.getClassName());
    }

    public String getClassName() {
        int n2 = this.iterator.u16bitAt(this.currentPos + 1);
        return this.getConstPool().getFieldrefClassName(n2);
    }

    public String getFieldName() {
        int n2 = this.iterator.u16bitAt(this.currentPos + 1);
        return this.getConstPool().getFieldrefName(n2);
    }

    public CtField getField() throws NotFoundException {
        CtClass ctClass = this.getCtClass();
        int n2 = this.iterator.u16bitAt(this.currentPos + 1);
        ConstPool constPool = this.getConstPool();
        return ctClass.getField(constPool.getFieldrefName(n2), constPool.getFieldrefType(n2));
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public String getSignature() {
        int n2 = this.iterator.u16bitAt(this.currentPos + 1);
        return this.getConstPool().getFieldrefType(n2);
    }

    @Override
    public void replace(String statement) throws CannotCompileException {
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int n2 = this.currentPos;
        int n3 = this.iterator.u16bitAt(n2 + 1);
        Javac javac = new Javac(this.thisClass);
        CodeAttribute codeAttribute = this.iterator.get();
        try {
            CtClass ctClass;
            CtClass[] ctClassArray;
            CtClass ctClass2 = Descriptor.toCtClass(constPool.getFieldrefType(n3), this.thisClass.getClassPool());
            boolean bl = this.isReader();
            if (bl) {
                ctClassArray = new CtClass[]{};
                ctClass = ctClass2;
            } else {
                CtClass[] ctClassArray2 = new CtClass[1];
                ctClassArray = ctClassArray2;
                ctClassArray2[0] = ctClass2;
                ctClass = CtClass.voidType;
            }
            int n4 = codeAttribute.getMaxLocals();
            javac.recordParams(constPool.getFieldrefClassName(n3), ctClassArray, true, n4, this.withinStatic());
            boolean bl2 = FieldAccess.checkResultValue(ctClass, statement);
            if (bl) {
                bl2 = true;
            }
            int n5 = javac.recordReturnType(ctClass, bl2);
            if (bl) {
                javac.recordProceed(new ProceedForRead(ctClass, this.opcode, n3, n4));
            } else {
                javac.recordType(ctClass2);
                javac.recordProceed(new ProceedForWrite(ctClassArray[0], this.opcode, n3, n4));
            }
            Bytecode bytecode = javac.getBytecode();
            FieldAccess.storeStack(ctClassArray, this.isStatic(), n4, bytecode);
            javac.recordLocalVariables(codeAttribute, n2);
            if (bl2) {
                if (ctClass == CtClass.voidType) {
                    bytecode.addOpcode(1);
                    bytecode.addAstore(n5);
                } else {
                    bytecode.addConstZero(ctClass);
                    bytecode.addStore(n5, ctClass);
                }
            }
            javac.compileStmnt(statement);
            if (bl) {
                bytecode.addLoad(n5, ctClass);
            }
            this.replace0(n2, bytecode, 3);
            return;
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("broken method");
        }
    }

    static class ProceedForWrite
    implements ProceedHandler {
        CtClass fieldType;
        int opcode;
        int targetVar;
        int index;

        ProceedForWrite(CtClass type, int op, int i2, int var) {
            this.fieldType = type;
            this.targetVar = var;
            this.opcode = op;
            this.index = i2;
        }

        @Override
        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args) throws CompileError {
            int n2;
            if (gen.getMethodArgsLength(args) != 1) {
                throw new CompileError("$proceed() cannot take more than one parameter for field writing");
            }
            if (FieldAccess.isStatic(this.opcode)) {
                n2 = 0;
            } else {
                n2 = -1;
                bytecode.addAload(this.targetVar);
            }
            gen.atMethodArgs(args, new int[1], new int[1], new String[1]);
            gen.doNumCast(this.fieldType);
            n2 = this.fieldType instanceof CtPrimitiveType ? (n2 -= ((CtPrimitiveType)this.fieldType).getDataSize()) : --n2;
            bytecode.add(this.opcode);
            bytecode.addIndex(this.index);
            bytecode.growStack(n2);
            gen.setType(CtClass.voidType);
            gen.addNullIfVoid();
        }

        @Override
        public void setReturnType(JvstTypeChecker c2, ASTList args) throws CompileError {
            c2.atMethodArgs(args, new int[1], new int[1], new String[1]);
            c2.setType(CtClass.voidType);
            c2.addNullIfVoid();
        }
    }

    static class ProceedForRead
    implements ProceedHandler {
        CtClass fieldType;
        int opcode;
        int targetVar;
        int index;

        ProceedForRead(CtClass type, int op, int i2, int var) {
            this.fieldType = type;
            this.targetVar = var;
            this.opcode = op;
            this.index = i2;
        }

        @Override
        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args) throws CompileError {
            int n2;
            if (args != null && !gen.isParamListName(args)) {
                throw new CompileError("$proceed() cannot take a parameter for field reading");
            }
            if (FieldAccess.isStatic(this.opcode)) {
                n2 = 0;
            } else {
                n2 = -1;
                bytecode.addAload(this.targetVar);
            }
            n2 = this.fieldType instanceof CtPrimitiveType ? (n2 += ((CtPrimitiveType)this.fieldType).getDataSize()) : ++n2;
            bytecode.add(this.opcode);
            bytecode.addIndex(this.index);
            bytecode.growStack(n2);
            gen.setType(this.fieldType);
        }

        @Override
        public void setReturnType(JvstTypeChecker c2, ASTList args) throws CompileError {
            c2.setType(this.fieldType);
        }
    }
}

