/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util;

import ai.h2o.javassist.util.Trigger;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HotSwapper {
    private VirtualMachine jvm = null;
    private MethodEntryRequest request = null;
    private Map<ReferenceType, byte[]> newClassFiles = null;
    private Trigger trigger = new Trigger();
    private static final String HOST_NAME = "localhost";
    private static final String TRIGGER_NAME = Trigger.class.getName();

    public HotSwapper(int port) throws IOException, IllegalConnectorArgumentsException {
        this(Integer.toString(port));
    }

    public HotSwapper(String port) throws IOException, IllegalConnectorArgumentsException {
        AttachingConnector attachingConnector = (AttachingConnector)this.findConnector("com.sun.jdi.SocketAttach");
        Map<String, Connector.Argument> map = attachingConnector.defaultArguments();
        map.get("hostname").setValue(HOST_NAME);
        map.get("port").setValue(port);
        this.jvm = attachingConnector.attach(map);
        EventRequestManager eventRequestManager = this.jvm.eventRequestManager();
        this.request = HotSwapper.methodEntryRequests(eventRequestManager, TRIGGER_NAME);
    }

    private Connector findConnector(String connector) throws IOException {
        List<Connector> list = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector2 : list) {
            if (!connector2.name().equals(connector)) continue;
            return connector2;
        }
        throw new IOException("Not found: " + connector);
    }

    private static MethodEntryRequest methodEntryRequests(EventRequestManager manager, String classpattern) {
        MethodEntryRequest methodEntryRequest = manager.createMethodEntryRequest();
        methodEntryRequest.addClassFilter(classpattern);
        methodEntryRequest.setSuspendPolicy(1);
        return methodEntryRequest;
    }

    private void deleteEventRequest(EventRequestManager manager, MethodEntryRequest request) {
        manager.deleteEventRequest(request);
    }

    public void reload(String className, byte[] classFile) {
        ReferenceType referenceType = this.toRefType(className);
        HashMap<ReferenceType, byte[]> hashMap = new HashMap<ReferenceType, byte[]>();
        hashMap.put(referenceType, classFile);
        this.reload2(hashMap, className);
    }

    public void reload(Map<String, byte[]> classFiles) {
        HashMap<ReferenceType, byte[]> hashMap = new HashMap<ReferenceType, byte[]>();
        String string = null;
        for (Map.Entry<String, byte[]> entry : classFiles.entrySet()) {
            string = entry.getKey();
            hashMap.put(this.toRefType(string), entry.getValue());
        }
        if (string != null) {
            this.reload2(hashMap, string + " etc.");
        }
    }

    private ReferenceType toRefType(String className) {
        List<ReferenceType> list = this.jvm.classesByName(className);
        if (list == null || list.isEmpty()) {
            throw new RuntimeException("no such class: " + className);
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload2(Map<ReferenceType, byte[]> map, String msg) {
        Trigger trigger = this.trigger;
        synchronized (trigger) {
            this.startDaemon();
            this.newClassFiles = map;
            this.request.enable();
            this.trigger.doSwap();
            this.request.disable();
            Map<ReferenceType, byte[]> map2 = this.newClassFiles;
            if (map2 != null) {
                this.newClassFiles = null;
                throw new RuntimeException("failed to reload: " + msg);
            }
            return;
        }
    }

    private void startDaemon() {
        new Thread(){

            private void errorMsg(Throwable e2) {
                System.err.print("Exception in thread \"HotSwap\" ");
                e2.printStackTrace(System.err);
            }

            @Override
            public void run() {
                EventSet eventSet = null;
                try {
                    eventSet = HotSwapper.this.waitEvent();
                    EventIterator eventIterator = eventSet.eventIterator();
                    while (eventIterator.hasNext()) {
                        Event event = eventIterator.nextEvent();
                        if (!(event instanceof MethodEntryEvent)) continue;
                        HotSwapper.this.hotswap();
                        break;
                    }
                }
                catch (Throwable throwable) {
                    this.errorMsg(throwable);
                }
                try {
                    if (eventSet != null) {
                        eventSet.resume();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    this.errorMsg(throwable);
                    return;
                }
            }
        }.start();
    }

    EventSet waitEvent() throws InterruptedException {
        EventQueue eventQueue = this.jvm.eventQueue();
        return eventQueue.remove();
    }

    void hotswap() {
        Map<ReferenceType, byte[]> map = this.newClassFiles;
        this.jvm.redefineClasses(map);
        this.newClassFiles = null;
    }
}

