/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.frame.MojoColumnFloat64;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.utils.Debug;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.KLimeModelPrediction;

public class KlimeTransform
extends MojoTransform {
    private final EasyPredictModelWrapper easyPredictModelWrapper;
    private final GenModel genModel;

    KlimeTransform(MojoFrameMeta meta, int[] iindices, int[] oindices, EasyPredictModelWrapper easyPredictModelWrapper) {
        super(meta, iindices, oindices);
        this.easyPredictModelWrapper = easyPredictModelWrapper;
        this.genModel = easyPredictModelWrapper.m;
    }

    @Override
    public void transform(MojoFrame frame) {
        int n2;
        ModelCategory modelCategory = this.genModel.getModelCategory();
        int n3 = this.iindices.length;
        int n4 = frame.getNrows();
        String[][] stringArrayArray = new String[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = this.iindices[n2];
            stringArrayArray[n2] = frame.getColumn(n5).getDataAsStrings();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            Object object;
            Object object2;
            int n6;
            RowData rowData = new RowData();
            for (int i2 = 0; i2 < n3; ++i2) {
                n6 = this.iindices[i2];
                object2 = frame.getColumnName(n6);
                object = stringArrayArray[i2][n2];
                if (object == null) continue;
                rowData.put(object2, object);
            }
            try {
                KLimeModelPrediction kLimeModelPrediction = this.easyPredictModelWrapper.predictKLime(rowData);
                block10: for (n6 = 0; n6 < this.genModel.getPredsSize(); ++n6) {
                    object2 = (MojoColumnFloat64)frame.getColumn(this.oindices[n6]);
                    object = (double[])((MojoColumnFloat64)object2).getData();
                    switch (n6) {
                        case 0: {
                            object[n2] = kLimeModelPrediction.value;
                            continue block10;
                        }
                        case 1: {
                            object[n2] = (double)kLimeModelPrediction.cluster;
                            continue block10;
                        }
                        default: {
                            object[n2] = kLimeModelPrediction.reasonCodes[n6 - 2];
                        }
                    }
                }
                continue;
            }
            catch (PredictException predictException) {
                if (Debug.getPrintH2O3Exceptions()) {
                    predictException.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed: %s", new Object[]{modelCategory, predictException.getMessage()}));
            }
            catch (Exception exception) {
                if (Debug.getPrintH2O3Exceptions()) {
                    exception.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed with %s: %s", new Object[]{modelCategory, exception.getClass().getName(), exception.getMessage()}));
            }
        }
    }
}

