/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.api.MojoTransformationGroup;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import java.util.Arrays;

public abstract class MojoTransform {
    public final int[] iindices;
    public final int[] oindices;
    public final MojoFrameMeta meta;
    private String id;
    private String name;
    private MojoTransformationGroup transformationGroup;

    public MojoTransform(MojoFrameMeta meta, int[] iindices, int[] oindices) {
        assert (iindices != null);
        assert (oindices != null);
        this.meta = meta;
        this.iindices = iindices;
        this.oindices = oindices;
    }

    public MojoColumn.Type[] getInputTypes() {
        MojoColumn.Type[] typeArray = new MojoColumn.Type[this.iindices.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = this.meta.getColumnType(this.iindices[i2]);
        }
        return typeArray;
    }

    public MojoColumn.Type getInputType(int idx) {
        return this.meta.getColumnType(this.iindices[idx]);
    }

    public MojoColumn.Type[] getOutputTypes() {
        MojoColumn.Type[] typeArray = new MojoColumn.Type[this.oindices.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = this.meta.getColumnType(this.oindices[i2]);
        }
        return typeArray;
    }

    public MojoColumn.Type getOutputType(int idx) {
        return this.meta.getColumnType(this.oindices[idx]);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MojoTransformationGroup getTransformationGroup() {
        return this.transformationGroup;
    }

    public void setTransformationGroup(MojoTransformationGroup transformationGroup) {
        this.transformationGroup = transformationGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void transform(MojoFrame var1);

    public String toString() {
        return String.format("%s:%s:%s->%s", this.id, this.getName(), Arrays.toString(this.iindices), Arrays.toString(this.oindices));
    }
}

