/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.MathUtils;
import java.util.Random;

public enum GlrmRegularizer {
    None{

        @Override
        public final double regularize(double[] u2) {
            return 0.0;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            return u2;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    Quadratic{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double d2 = 0.0;
            double[] dArray = u2;
            int n2 = u2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d3;
                double d4 = d3 = dArray[i2];
                d2 += d4 * d4;
            }
            return d2;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] dArray = new double[u2.length];
            double d2 = 1.0 / (1.0 + delta * 2.0);
            for (int i2 = 0; i2 < u2.length; ++i2) {
                dArray[i2] = u2[i2] * d2;
            }
            return dArray;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    L2{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double d2 = 0.0;
            double[] dArray = u2;
            int n2 = u2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d3;
                double d4 = d3 = dArray[i2];
                d2 += d4 * d4;
            }
            return Math.sqrt(d2);
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            double d2;
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] dArray = new double[u2.length];
            double d3 = 1.0 - delta / ArrayUtils.l2norm(u2);
            if (d2 < 0.0) {
                return dArray;
            }
            for (int i2 = 0; i2 < u2.length; ++i2) {
                dArray[i2] = d3 * u2[i2];
            }
            return dArray;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    L1{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double d2 = 0.0;
            double[] dArray = u2;
            int n2 = u2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d3 = dArray[i2];
                d2 += Math.abs(d3);
            }
            return d2;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] dArray = new double[u2.length];
            for (int i2 = 0; i2 < u2.length; ++i2) {
                dArray[i2] = Math.max(u2[i2] - delta, 0.0) + Math.min(u2[i2] + delta, 0.0);
            }
            return dArray;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            return u2;
        }
    }
    ,
    NonNegative{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double[] dArray = u2;
            int n2 = u2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2;
                double d3 = dArray[i2];
                if (!(d2 < 0.0)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] dArray = new double[u2.length];
            for (int i2 = 0; i2 < u2.length; ++i2) {
                dArray[i2] = Math.max(u2[i2], 0.0);
            }
            return dArray;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            if (u2 == null) {
                return null;
            }
            return this.rproxgrad(u2, 1.0, rand);
        }
    }
    ,
    OneSparse{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            int n2 = 0;
            double[] dArray = u2;
            int n3 = u2.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                double d2;
                double d3 = dArray[i2];
                if (d2 < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                if (!(d3 > 0.0)) continue;
                ++n2;
            }
            if (n2 == 1) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] dArray = new double[u2.length];
            int n2 = ArrayUtils.maxIndex(u2, rand);
            double d2 = u2[n2] > 0.0 ? u2[n2] : 1.0E-6;
            dArray[n2] = d2;
            return dArray;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            if (u2 == null) {
                return null;
            }
            return this.rproxgrad(u2, 1.0, rand);
        }
    }
    ,
    UnitOneSparse{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            int n2 = 0;
            int n3 = 0;
            double[] dArray = u2;
            int n4 = u2.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                double d2 = dArray[i2];
                if (d2 == 1.0) {
                    ++n2;
                    continue;
                }
                if (d2 == 0.0) {
                    ++n3;
                    continue;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (n2 == 1 && n3 == u2.length - 1) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            double[] dArray = new double[u2.length];
            int n2 = ArrayUtils.maxIndex(u2, rand);
            dArray[n2] = 1.0;
            return dArray;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            if (u2 == null) {
                return null;
            }
            return this.rproxgrad(u2, 1.0, rand);
        }
    }
    ,
    Simplex{

        @Override
        public final double regularize(double[] u2) {
            if (u2 == null) {
                return 0.0;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double[] dArray = u2;
            int n2 = u2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d4;
                double d5 = dArray[i2];
                if (d4 < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                d2 += d5;
                d3 += Math.abs(d5);
            }
            if (MathUtils.equalsWithinRecSumErr(d2, 1.0, u2.length, d3)) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public final double[] rproxgrad(double[] u2, double delta, Random rand) {
            if (u2 == null || delta == 0.0) {
                return u2;
            }
            int n2 = u2.length;
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3++;
                nArray[n4] = n4;
            }
            ArrayUtils.sort(nArray, u2);
            double[] dArray = new double[n2];
            double[] dArray2 = dArray;
            dArray[n2 - 1] = u2[nArray[n2 - 1]];
            for (int i2 = n2 - 2; i2 >= 0; --i2) {
                dArray2[i2] = dArray2[i2 + 1] + u2[nArray[i2]];
            }
            double d2 = (dArray2[0] - 1.0) / (double)n2;
            for (int i3 = n2 - 1; i3 > 0; --i3) {
                double d3;
                double d4 = (dArray2[i3] - 1.0) / (double)(n2 - i3);
                if (!(d3 >= u2[nArray[i3 - 1]])) continue;
                d2 = d4;
                break;
            }
            double[] dArray3 = new double[u2.length];
            for (int i4 = 0; i4 < u2.length; ++i4) {
                dArray3[i4] = Math.max(u2[i4] - d2, 0.0);
            }
            return dArray3;
        }

        @Override
        public final double[] project(double[] u2, Random rand) {
            double d2 = this.regularize(u2);
            if (d2 == 0.0) {
                return u2;
            }
            return this.rproxgrad(u2, 1.0, rand);
        }
    };


    public abstract double regularize(double[] var1);

    public final double regularize(double[][] u2) {
        double[] dArray;
        if (u2 == null || this == None) {
            return 0.0;
        }
        double d2 = 0.0;
        double[][] dArray2 = u2;
        int n2 = u2.length;
        for (int i2 = 0; i2 < n2 && !Double.isInfinite(d2 += this.regularize(dArray = dArray2[i2])); ++i2) {
        }
        return d2;
    }

    public abstract double[] rproxgrad(double[] var1, double var2, Random var4);

    public abstract double[] project(double[] var1, Random var2);
}

