/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.TreeSHAPPredictor;
import java.util.Collection;

public class TreeSHAPEnsemble<R>
implements TreeSHAPPredictor<R> {
    private final TreeSHAPPredictor<R>[] _predictors;
    private final float _initPred;
    private final int _wsMakerIndex;

    public TreeSHAPEnsemble(Collection<TreeSHAPPredictor<R>> predictors, float initPred) {
        this._predictors = predictors.toArray(new TreeSHAPPredictor[0]);
        this._initPred = initPred;
        this._wsMakerIndex = TreeSHAPEnsemble.findWorkspaceMaker(this._predictors);
    }

    @Override
    public float[] calculateContributions(R feat, float[] out_contribs) {
        return this.calculateContributions(feat, out_contribs, 0, -1, this.makeWorkspace());
    }

    @Override
    public float[] calculateContributions(R feat, float[] out_contribs, int condition, int condition_feature, Object workspace) {
        if (condition == 0) {
            float[] fArray = out_contribs;
            int n2 = out_contribs.length - 1;
            fArray[n2] = fArray[n2] + this._initPred;
        }
        TreeSHAPPredictor<R>[] treeSHAPPredictorArray = this._predictors;
        int n3 = this._predictors.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            TreeSHAPPredictor<R> treeSHAPPredictor = treeSHAPPredictorArray[i2];
            treeSHAPPredictor.calculateContributions(feat, out_contribs, condition, condition_feature, workspace);
        }
        return out_contribs;
    }

    @Override
    public Object makeWorkspace() {
        if (this._wsMakerIndex >= 0) {
            return this._predictors[this._wsMakerIndex].makeWorkspace();
        }
        return null;
    }

    @Override
    public int getWorkspaceSize() {
        if (this._wsMakerIndex >= 0) {
            return this._predictors[this._wsMakerIndex].getWorkspaceSize();
        }
        return 0;
    }

    private static int findWorkspaceMaker(TreeSHAPPredictor<?>[] predictors) {
        if (predictors.length == 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < predictors.length; ++i2) {
            int n4 = predictors[i2].getWorkspaceSize();
            if (n4 <= n2) continue;
            n2 = n4;
            n3 = i2;
        }
        return n3;
    }
}

