/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;

class BeanIntrospectionData {
    private final PropertyDescriptor[] descriptors;
    private final Map<String, String> writeMethodNames;

    public BeanIntrospectionData(PropertyDescriptor[] descs) {
        this(descs, BeanIntrospectionData.setUpWriteMethodNames(descs));
    }

    BeanIntrospectionData(PropertyDescriptor[] descs, Map<String, String> writeMethNames) {
        this.descriptors = descs;
        this.writeMethodNames = writeMethNames;
    }

    public PropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public PropertyDescriptor getDescriptor(String name) {
        for (PropertyDescriptor propertyDescriptor : this.getDescriptors()) {
            if (!name.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public Method getWriteMethod(Class<?> beanCls, PropertyDescriptor desc) {
        String string;
        Method method = desc.getWriteMethod();
        if (method == null && (string = this.writeMethodNames.get(desc.getName())) != null && (method = MethodUtils.getAccessibleMethod(beanCls, string, desc.getPropertyType())) != null) {
            try {
                desc.setWriteMethod(method);
            }
            catch (IntrospectionException introspectionException) {}
        }
        return method;
    }

    private static Map<String, String> setUpWriteMethodNames(PropertyDescriptor[] descs) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PropertyDescriptor[] propertyDescriptorArray = descs;
        int n2 = descs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) continue;
            hashMap.put(propertyDescriptor.getName(), method.getName());
        }
        return hashMap;
    }
}

