/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyValueEqualsPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Object propertyValue;
    private boolean ignoreNull;

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName != null && propertyName.length() > 0) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.ignoreNull = ignoreNull;
            return;
        }
        throw new IllegalArgumentException("propertyName cannot be null or empty");
    }

    @Override
    public boolean evaluate(Object object) {
        boolean bl = false;
        try {
            BeanPropertyValueEqualsPredicate beanPropertyValueEqualsPredicate = this;
            bl = beanPropertyValueEqualsPredicate.evaluateValue(beanPropertyValueEqualsPredicate.propertyValue, PropertyUtils.getProperty(object, this.propertyName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during evaluation. Null value encountered in property path..." + illegalArgumentException);
            }
            IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("Problem during evaluation. Null value encountered in property path...");
            if (!BeanUtils.initCause(illegalArgumentException2, illegalArgumentException)) {
                this.log.error("Problem during evaluation. Null value encountered in property path...", illegalArgumentException);
            }
            throw illegalArgumentException2;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to access the property provided.");
            if (!BeanUtils.initCause(illegalArgumentException, illegalAccessException)) {
                this.log.error("Unable to access the property provided.", illegalAccessException);
            }
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception occurred in property's getter");
            if (!BeanUtils.initCause(illegalArgumentException, invocationTargetException)) {
                this.log.error("Exception occurred in property's getter", invocationTargetException);
            }
            throw illegalArgumentException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Property not found.");
            if (!BeanUtils.initCause(illegalArgumentException, noSuchMethodException)) {
                this.log.error("Property not found.", noSuchMethodException);
            }
            throw illegalArgumentException;
        }
        return bl;
    }

    protected boolean evaluateValue(Object expected, Object actual) {
        return expected == actual || expected != null && expected.equals(actual);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

