/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanPropertyMapDecorator;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyDynaBean
implements Serializable,
DynaBean {
    private transient Log logger = LogFactory.getLog(LazyDynaBean.class);
    protected static final BigInteger BigInteger_ZERO = new BigInteger("0");
    protected static final BigDecimal BigDecimal_ZERO = new BigDecimal("0");
    protected static final Character Character_SPACE = Character.valueOf(' ');
    protected static final Byte Byte_ZERO = 0;
    protected static final Short Short_ZERO = 0;
    protected static final Integer Integer_ZERO = 0;
    protected static final Long Long_ZERO = 0L;
    protected static final Float Float_ZERO = Float.valueOf(0.0f);
    protected static final Double Double_ZERO = 0.0;
    protected Map<String, Object> values = this.newMap();
    private transient Map<String, Object> mapDecorator;
    protected MutableDynaClass dynaClass;

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String name) {
        this(new LazyDynaClass(name));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        if (dynaClass instanceof MutableDynaClass) {
            this.dynaClass = (MutableDynaClass)dynaClass;
            return;
        }
        this.dynaClass = new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map<String, Object> getMap() {
        if (this.mapDecorator == null) {
            this.mapDecorator = new DynaBeanPropertyMapDecorator(this);
        }
        return this.mapDecorator;
    }

    public int size(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(name);
        if (object == null) {
            return 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof List) {
            return ((List)object).size();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        return 0;
    }

    @Override
    public boolean contains(String name, String key) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(name);
        if (object == null) {
            return false;
        }
        if (object instanceof Map) {
            return ((Map)object).containsKey(key);
        }
        return false;
    }

    @Override
    public Object get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(name);
        if (object != null) {
            return object;
        }
        if (!this.isDynaProperty(name)) {
            return null;
        }
        object = this.createProperty(name, this.dynaClass.getDynaProperty(name).getType());
        if (object != null) {
            this.set(name, object);
        }
        return object;
    }

    @Override
    public Object get(String name, int index) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultIndexedProperty(name));
        }
        Object object = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + this.dynaClass.getDynaProperty(name).getName());
        }
        if ((object = this.growIndexedProperty(name, object, index)).getClass().isArray()) {
            return Array.get(object, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + object.getClass().getName());
    }

    @Override
    public Object get(String name, String key) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultMappedProperty(name));
        }
        Object object = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")' " + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        if (object instanceof Map) {
            return ((Map)object).get(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + object.getClass().getName());
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name, String key) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(name);
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            ((Map)object).remove(key);
            return;
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + object.getClass().getName());
    }

    @Override
    public void set(String name, Object value) {
        if (!this.isDynaProperty(name)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + name + "' (DynaClass is restricted)");
            }
            if (value == null) {
                this.dynaClass.add(name);
            } else {
                this.dynaClass.add(name, value.getClass());
            }
        }
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(name);
        if (value == null) {
            if (dynaProperty.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(dynaProperty.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + dynaProperty.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    @Override
    public void set(String name, int index, Object value) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultIndexedProperty(name));
        }
        Object object = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'" + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        if ((object = this.growIndexedProperty(name, object, index)).getClass().isArray()) {
            Array.set(object, index, value);
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            list.set(index, value);
            return;
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + object.getClass().getName());
    }

    @Override
    public void set(String name, String key, Object value) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultMappedProperty(name));
        }
        Object object = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        Map map = (Map)object;
        map.put(key, value);
    }

    protected Object growIndexedProperty(String name, Object indexedProperty, int index) {
        int n2;
        Object object;
        Class<?> clazz;
        if (indexedProperty instanceof List) {
            List list = (List)indexedProperty;
            while (index >= list.size()) {
                clazz = this.getDynaClass().getDynaProperty(name).getContentType();
                object = null;
                if (clazz != null) {
                    object = this.createProperty(name + "[" + list.size() + "]", clazz);
                }
                list.add(object);
            }
        }
        if (indexedProperty.getClass().isArray() && index >= (n2 = Array.getLength(indexedProperty))) {
            clazz = indexedProperty.getClass().getComponentType();
            object = Array.newInstance(clazz, index + 1);
            System.arraycopy(indexedProperty, 0, object, 0, n2);
            indexedProperty = object;
            this.set(name, indexedProperty);
            int n3 = Array.getLength(indexedProperty);
            for (int i2 = n2; i2 < n3; ++i2) {
                Array.set(indexedProperty, i2, this.createProperty(name + "[" + i2 + "]", clazz));
            }
        }
        return indexedProperty;
    }

    protected Object createProperty(String name, Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isArray() || List.class.isAssignableFrom(type)) {
            return this.createIndexedProperty(name, type);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.createMappedProperty(name, type);
        }
        if (DynaBean.class.isAssignableFrom(type)) {
            return this.createDynaBeanProperty(name, type);
        }
        if (type.isPrimitive()) {
            return this.createPrimitiveProperty(name, type);
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.createNumberProperty(name, type);
        }
        return this.createOtherProperty(name, type);
    }

    protected Object createIndexedProperty(String name, Class<?> type) {
        Object indexedProperty;
        if (type == null) {
            indexedProperty = this.defaultIndexedProperty(name);
        } else if (type.isArray()) {
            indexedProperty = Array.newInstance(type.getComponentType(), 0);
        } else if (List.class.isAssignableFrom(type)) {
            if (type.isInterface()) {
                indexedProperty = this.defaultIndexedProperty(name);
            } else {
                try {
                    indexedProperty = type.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Error instantiating indexed property of type '" + type.getName() + "' for '" + name + "' " + exception);
                }
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property of type '" + type.getName() + "' for '" + name + "'");
        }
        return indexedProperty;
    }

    protected Object createMappedProperty(String name, Class<?> type) {
        Map<String, Object> mappedProperty;
        if (type == null) {
            mappedProperty = this.defaultMappedProperty(name);
        } else if (type.isInterface()) {
            mappedProperty = this.defaultMappedProperty(name);
        } else if (Map.class.isAssignableFrom(type)) {
            try {
                mappedProperty = type.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error instantiating mapped property of type '" + type.getName() + "' for '" + name + "' " + exception);
            }
        } else {
            throw new IllegalArgumentException("Non-mapped property of type '" + type.getName() + "' for '" + name + "'");
        }
        return mappedProperty;
    }

    protected Object createDynaBeanProperty(String name, Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (Exception exception) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn("Error instantiating DynaBean property of type '" + type.getName() + "' for '" + name + "' " + exception);
            }
            return null;
        }
    }

    protected Object createPrimitiveProperty(String name, Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (type == Long.TYPE) {
            return Long_ZERO;
        }
        if (type == Double.TYPE) {
            return Double_ZERO;
        }
        if (type == Float.TYPE) {
            return Float_ZERO;
        }
        if (type == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (type == Short.TYPE) {
            return Short_ZERO;
        }
        if (type == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    protected Object createNumberProperty(String name, Class<?> type) {
        return null;
    }

    protected Object createOtherProperty(String name, Class<?> type) {
        if (type == Object.class || type == String.class || type == Boolean.class || type == Character.class || Date.class.isAssignableFrom(type)) {
            return null;
        }
        try {
            return type.newInstance();
        }
        catch (Exception exception) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn("Error instantiating property of type '" + type.getName() + "' for '" + name + "' " + exception);
            }
            return null;
        }
    }

    protected Object defaultIndexedProperty(String name) {
        return new ArrayList();
    }

    protected Map<String, Object> defaultMappedProperty(String name) {
        return new HashMap<String, Object>();
    }

    protected boolean isDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(name);
        }
        return this.dynaClass.getDynaProperty(name) != null;
    }

    protected boolean isAssignable(Class<?> dest, Class<?> source) {
        return dest.isAssignableFrom(source) || dest == Boolean.TYPE && source == Boolean.class || dest == Byte.TYPE && source == Byte.class || dest == Character.TYPE && source == Character.class || dest == Double.TYPE && source == Double.class || dest == Float.TYPE && source == Float.class || dest == Integer.TYPE && source == Integer.class || dest == Long.TYPE && source == Long.class || dest == Short.TYPE && source == Short.class;
    }

    protected Map<String, Object> newMap() {
        return new HashMap<String, Object>();
    }

    private Log logger() {
        if (this.logger == null) {
            this.logger = LogFactory.getLog(LazyDynaBean.class);
        }
        return this.logger;
    }
}

