/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConverter
implements Converter {
    private static final String DEFAULT_CONFIG_MSG = "(N.B. Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "org.apache.commons.beanutils.converters.";
    private transient Log log;
    private boolean useDefault = false;
    private Object defaultValue = null;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public <T> T convert(Class<T> type, Object value) {
        if (type == null) {
            return this.convertToDefaultType(type, value);
        }
        Class<?> clazz = value == null ? null : value.getClass();
        Class<T> clazz2 = ConvertUtils.primitiveToWrapper(type);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Converting" + (value == null ? "" : " '" + this.toString(clazz) + "'") + " value '" + value + "' to type '" + this.toString(clazz2) + "'");
        }
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(clazz2);
        }
        clazz = value.getClass();
        try {
            if (clazz2.equals(String.class)) {
                return clazz2.cast(this.convertToString(value));
            }
            if (clazz2.equals(clazz)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    No conversion required, value is already a " + this.toString(clazz2));
                }
                return clazz2.cast(value);
            }
            T t2 = this.convertToType(clazz2, value);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted to " + this.toString(clazz2) + " value '" + t2 + "'");
            }
            return clazz2.cast(t2);
        }
        catch (Throwable throwable) {
            return this.handleError(clazz2, value, throwable);
        }
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected abstract <T> T convertToType(Class<T> var1, Object var2) throws Throwable;

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    protected <T> T handleError(Class<T> type, Object value, Throwable cause) {
        ConversionException conversionException;
        if (this.log().isDebugEnabled()) {
            if (cause instanceof ConversionException) {
                this.log().debug("    Conversion threw ConversionException: " + cause.getMessage());
            } else {
                this.log().debug("    Conversion threw " + cause);
            }
        }
        if (this.useDefault) {
            return this.handleMissing(type);
        }
        if (cause instanceof ConversionException) {
            conversionException = (ConversionException)cause;
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Re-throwing ConversionException: " + conversionException.getMessage());
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
        } else {
            String string = "Error converting from '" + this.toString(value.getClass()) + "' to '" + this.toString(type) + "' " + cause.getMessage();
            conversionException = new ConversionException(string, cause);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Throwing ConversionException: " + string);
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
            BeanUtils.initCause(conversionException, cause);
        }
        throw conversionException;
    }

    protected <T> T handleMissing(Class<T> type) {
        if (this.useDefault || type.equals(String.class)) {
            Object object = this.getDefault(type);
            if (this.useDefault && object != null && !type.equals(object.getClass())) {
                try {
                    object = this.convertToType(type, this.defaultValue);
                }
                catch (Throwable throwable) {
                    throw new ConversionException("Default conversion to " + this.toString(type) + " failed.", throwable);
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default " + (object == null ? "" : this.toString(object.getClass()) + " ") + "value '" + this.defaultValue + "'");
            }
            return type.cast(object);
        }
        ConversionException conversionException = new ConversionException("No value specified for '" + this.toString(type) + "'");
        if (this.log().isDebugEnabled()) {
            this.log().debug("    Throwing ConversionException: " + conversionException.getMessage());
            this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
        }
        throw conversionException;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Setting default value: " + defaultValue);
        }
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class<?> getDefaultType();

    protected Object getDefault(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        AbstractConverter abstractConverter = this;
        return abstractConverter.toString(abstractConverter.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    String toString(Class<?> type) {
        String typeName;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> clazz = type.getComponentType();
            int n2 = 1;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++n2;
            }
            typeName = clazz.getName();
            for (int i2 = 0; i2 < n2; ++i2) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring(10);
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(40);
        }
        return typeName;
    }

    private <T> T convertToDefaultType(Class<T> targetClass, Object value) {
        AbstractConverter abstractConverter = this;
        Object obj = abstractConverter.convert(abstractConverter.getDefaultType(), value);
        return (T)obj;
    }

    protected ConversionException conversionException(Class<?> type, Object value) {
        return new ConversionException("Can't convert value '" + value + "' to type " + type);
    }
}

