/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.expression;

import org.apache.commons.beanutils.expression.Resolver;

public class DefaultResolver
implements Resolver {
    private static final char NESTED = '.';
    private static final char MAPPED_START = '(';
    private static final char MAPPED_END = ')';
    private static final char INDEXED_START = '[';
    private static final char INDEXED_END = ']';

    @Override
    public int getIndex(String expression) {
        if (expression == null || expression.length() == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            int n2;
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '(') {
                return -1;
            }
            if (c2 != '[') continue;
            int n3 = expression.indexOf(93, i2);
            if (n3 < 0) {
                throw new IllegalArgumentException("Missing End Delimiter");
            }
            String string = expression.substring(i2 + 1, n3);
            if (string.length() == 0) {
                throw new IllegalArgumentException("No Index Value");
            }
            try {
                n2 = Integer.parseInt(string, 10);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid index value '" + string + "'");
            }
            return n2;
        }
        return -1;
    }

    @Override
    public String getKey(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '[') {
                return null;
            }
            if (c2 != '(') continue;
            int n2 = expression.indexOf(41, i2);
            if (n2 < 0) {
                throw new IllegalArgumentException("Missing End Delimiter");
            }
            return expression.substring(i2 + 1, n2);
        }
        return null;
    }

    @Override
    public String getProperty(String expression) {
        if (expression == null || expression.length() == 0) {
            return expression;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.') {
                return expression.substring(0, i2);
            }
            if (c2 != '(' && c2 != '[') continue;
            return expression.substring(0, i2);
        }
        return expression;
    }

    @Override
    public boolean hasNested(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return this.remove(expression) != null;
    }

    @Override
    public boolean isIndexed(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '(') {
                return false;
            }
            if (c2 != '[') continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMapped(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 == '.' || c2 == '[') {
                return false;
            }
            if (c2 != '(') continue;
            return true;
        }
        return false;
    }

    @Override
    public String next(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < expression.length(); ++i2) {
            char c2 = expression.charAt(i2);
            if (bl) {
                if (c2 != ']') continue;
                return expression.substring(0, i2 + 1);
            }
            if (bl2) {
                if (c2 != ')') continue;
                return expression.substring(0, i2 + 1);
            }
            if (c2 == '.') {
                return expression.substring(0, i2);
            }
            if (c2 == '(') {
                bl2 = true;
                continue;
            }
            if (c2 != '[') continue;
            bl = true;
        }
        return expression;
    }

    @Override
    public String remove(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        String string = this.next(expression);
        if (expression.length() == string.length()) {
            return null;
        }
        int n2 = string.length();
        if (expression.charAt(n2) == '.') {
            ++n2;
        }
        return expression.substring(n2);
    }
}

