/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.Unmodifiable;

public final class UnmodifiableOrderedMapIterator
implements OrderedMapIterator,
Unmodifiable {
    private OrderedMapIterator iterator;

    public static OrderedMapIterator decorate(OrderedMapIterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("OrderedMapIterator must not be null");
        }
        if (iterator instanceof Unmodifiable) {
            return iterator;
        }
        return new UnmodifiableOrderedMapIterator(iterator);
    }

    private UnmodifiableOrderedMapIterator(OrderedMapIterator iterator) {
        this.iterator = iterator;
    }

    public final boolean hasNext() {
        return this.iterator.hasNext();
    }

    public final Object next() {
        return this.iterator.next();
    }

    public final boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    public final Object previous() {
        return this.iterator.previous();
    }

    public final Object getKey() {
        return this.iterator.getKey();
    }

    public final Object getValue() {
        return this.iterator.getValue();
    }

    public final Object setValue(Object value) {
        throw new UnsupportedOperationException("setValue() is not supported");
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

