/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.CharUtils;

public class StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        CharSequence[] charSequenceArray = css;
        int n2 = css.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneEmpty(CharSequence ... css) {
        return !StringUtils.isAnyEmpty(css);
    }

    public static boolean isAllEmpty(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        CharSequence[] charSequenceArray = css;
        int n2 = css.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        int n2;
        if (cs == null || (n2 = cs.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        CharSequence[] charSequenceArray = css;
        int n2 = css.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return !StringUtils.isAnyBlank(css);
    }

    public static boolean isAllBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        CharSequence[] charSequenceArray = css;
        int n2 = css.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.isNotBlank(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static String trimToNull(String str) {
        String string = StringUtils.trim(str);
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    public static String trimToEmpty(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str.trim();
    }

    public static String truncate(String str, int maxWidth) {
        return StringUtils.truncate(str, 0, maxWidth);
    }

    public static String truncate(String str, int offset, int maxWidth) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str == null) {
            return null;
        }
        if (offset > str.length()) {
            return EMPTY;
        }
        if (str.length() > maxWidth) {
            int n2 = offset + maxWidth > str.length() ? str.length() : offset + maxWidth;
            return str.substring(offset, n2);
        }
        return str.substring(offset);
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String stripToNull(String str) {
        if (str == null) {
            return null;
        }
        if ((str = StringUtils.strip(str, null)).isEmpty()) {
            return null;
        }
        return str;
    }

    public static String stripToEmpty(String str) {
        if (str == null) {
            return EMPTY;
        }
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        str = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(str, stripChars);
    }

    public static String stripStart(String str, String stripChars) {
        int n2;
        int n3;
        if (str == null || (n3 = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (n2 = 0; n2 != n3 && Character.isWhitespace(str.charAt(n2)); ++n2) {
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (n2 != n3 && stripChars.indexOf(str.charAt(n2)) != -1) {
                ++n2;
            }
        }
        return str.substring(n2);
    }

    public static String stripEnd(String str, String stripChars) {
        int n2;
        if (str == null || (n2 = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (n2 != 0 && Character.isWhitespace(str.charAt(n2 - 1))) {
                --n2;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (n2 != 0 && stripChars.indexOf(str.charAt(n2 - 1)) != -1) {
                --n2;
            }
        }
        return str.substring(0, n2);
    }

    public static String[] stripAll(String ... strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String stripChars) {
        int n2;
        if (strs == null || (n2 = strs.length) == 0) {
            return strs;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = StringUtils.strip(strs[i2], stripChars);
        }
        return stringArray;
    }

    public static String stripAccents(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        StringBuilder stringBuilder = new StringBuilder(Normalizer.normalize(input, Normalizer.Form.NFD));
        StringUtils.convertRemainingAccentCharacters(stringBuilder);
        return pattern.matcher(stringBuilder).replaceAll(EMPTY);
    }

    private static void convertRemainingAccentCharacters(StringBuilder decomposed) {
        for (int i2 = 0; i2 < decomposed.length(); ++i2) {
            if (decomposed.charAt(i2) == '\u0141') {
                decomposed.deleteCharAt(i2);
                decomposed.insert(i2, 'L');
                continue;
            }
            if (decomposed.charAt(i2) != '\u0142') continue;
            decomposed.deleteCharAt(i2);
            decomposed.insert(i2, 'l');
        }
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        return CharSequenceUtils.regionMatches(cs1, false, 0, cs2, 0, cs1.length());
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        if (str1 == str2) {
            return true;
        }
        if (str1.length() != str2.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(str1, true, 0, str2, 0, str1.length());
    }

    public static int compare(String str1, String str2) {
        return StringUtils.compare(str1, str2, true);
    }

    public static int compare(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            if (nullIsLess) {
                return 1;
            }
            return -1;
        }
        return str1.compareTo(str2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        return StringUtils.compareIgnoreCase(str1, str2, true);
    }

    public static int compareIgnoreCase(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            if (nullIsLess) {
                return 1;
            }
            return -1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            CharSequence[] charSequenceArray = searchStrings;
            int n2 = searchStrings.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CharSequence charSequence = charSequenceArray[i2];
                if (!StringUtils.equals(string, charSequence)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            CharSequence[] charSequenceArray = searchStrings;
            int n2 = searchStrings.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CharSequence charSequence = charSequenceArray[i2];
                if (!StringUtils.equalsIgnoreCase(string, charSequence)) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence seq, int searchChar) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchChar, 0);
    }

    public static int indexOf(CharSequence seq, int searchChar, int startPos) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchChar, startPos);
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, 0);
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, startPos);
    }

    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        return StringUtils.ordinalIndexOf(str, searchStr, ordinal, false);
    }

    private static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal, boolean lastIndex) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            if (lastIndex) {
                return str.length();
            }
            return 0;
        }
        int n2 = 0;
        int n3 = lastIndex ? str.length() : -1;
        do {
            if ((n3 = lastIndex ? CharSequenceUtils.lastIndexOf(str, searchStr, n3 - 1) : CharSequenceUtils.indexOf(str, searchStr, n3 + 1)) >= 0) continue;
            return n3;
        } while (++n2 < ordinal);
        return n3;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        int n2;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (n2 = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < n2; ++i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, searchStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence seq, int searchChar) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchChar, seq.length());
    }

    public static int lastIndexOf(CharSequence seq, int searchChar, int startPos) {
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchChar, startPos);
    }

    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchSeq, seq.length());
    }

    public static int lastOrdinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        return StringUtils.ordinalIndexOf(str, searchStr, ordinal, true);
    }

    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, searchSeq, startPos);
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos > str.length() - searchStr.length()) {
            startPos = str.length() - searchStr.length();
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 >= 0; --i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, searchStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(CharSequence seq, int searchChar) {
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        return CharSequenceUtils.indexOf(seq, searchChar, 0) >= 0;
    }

    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return false;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, 0) >= 0;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int n2 = searchStr.length();
        int n3 = str.length() - n2;
        for (int i2 = 0; i2 <= n3; ++i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, n2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        int n2 = seq.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isWhitespace(seq.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static int indexOfAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int n2 = cs.length();
        int n3 = n2 - 1;
        int n4 = searchChars.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cs.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (searchChars[i3] != c2) continue;
                if (i2 < n3 && i3 < n5 && Character.isHighSurrogate(c2)) {
                    if (searchChars[i3 + 1] != cs.charAt(i2 + 1)) continue;
                    return i2;
                }
                return i2;
            }
        }
        return -1;
    }

    public static int indexOfAny(CharSequence cs, String searchChars) {
        if (StringUtils.isEmpty(cs) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        return StringUtils.indexOfAny(cs, searchChars.toCharArray());
    }

    public static boolean containsAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return false;
        }
        int n2 = cs.length();
        int n3 = searchChars.length;
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cs.charAt(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                if (searchChars[i3] != c2) continue;
                if (Character.isHighSurrogate(c2)) {
                    if (i3 == n5) {
                        return true;
                    }
                    if (i2 >= n4 || searchChars[i3 + 1] != cs.charAt(i2 + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence cs, CharSequence searchChars) {
        if (searchChars == null) {
            return false;
        }
        return StringUtils.containsAny(cs, CharSequenceUtils.toCharArray(searchChars));
    }

    public static boolean containsAny(CharSequence cs, CharSequence ... searchCharSequences) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchCharSequences)) {
            return false;
        }
        CharSequence[] charSequenceArray = searchCharSequences;
        int n2 = searchCharSequences.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.contains(cs, charSequence)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfAnyBut(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int n2 = cs.length();
        int n3 = n2 - 1;
        int n4 = searchChars.length;
        int n5 = n4 - 1;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cs.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (searchChars[i3] == c2 && (i2 >= n3 || i3 >= n5 || !Character.isHighSurrogate(c2) || searchChars[i3 + 1] == cs.charAt(i2 + 1))) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence seq, CharSequence searchChars) {
        if (StringUtils.isEmpty(seq) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        int n2 = seq.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            char c2 = seq.charAt(i2);
            boolean bl2 = bl = CharSequenceUtils.indexOf(searchChars, c2, 0) >= 0;
            if (i2 + 1 < n2 && Character.isHighSurrogate(c2)) {
                char c3 = seq.charAt(i2 + 1);
                if (!bl || CharSequenceUtils.indexOf(searchChars, c3, 0) >= 0) continue;
                return i2;
            }
            if (bl) continue;
            return i2;
        }
        return -1;
    }

    public static boolean containsOnly(CharSequence cs, char ... valid) {
        if (valid == null || cs == null) {
            return false;
        }
        if (cs.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(cs, valid) == -1;
    }

    public static boolean containsOnly(CharSequence cs, String validChars) {
        if (cs == null || validChars == null) {
            return false;
        }
        return StringUtils.containsOnly(cs, validChars.toCharArray());
    }

    public static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int n2 = cs.length();
        int n3 = n2 - 1;
        int n4 = searchChars.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cs.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (searchChars[i3] != c2) continue;
                if (Character.isHighSurrogate(c2)) {
                    if (i3 == n5) {
                        return false;
                    }
                    if (i2 >= n3 || searchChars[i3 + 1] != cs.charAt(i2 + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(CharSequence cs, String invalidChars) {
        if (cs == null || invalidChars == null) {
            return true;
        }
        return StringUtils.containsNone(cs, invalidChars.toCharArray());
    }

    public static int indexOfAny(CharSequence str, CharSequence ... searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int n2 = Integer.MAX_VALUE;
        CharSequence[] charSequenceArray = searchStrs;
        int n3 = searchStrs.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            CharSequence charSequence = charSequenceArray[i2];
            if (charSequence == null || (n4 = CharSequenceUtils.indexOf(str, charSequence, 0)) == -1 || n4 >= n2) continue;
            n2 = n4;
        }
        if (n2 == Integer.MAX_VALUE) {
            return -1;
        }
        return n2;
    }

    public static int lastIndexOfAny(CharSequence str, CharSequence ... searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int n2 = -1;
        CharSequence[] charSequenceArray = searchStrs;
        int n3 = searchStrs.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            CharSequence charSequence = charSequenceArray[i2];
            if (charSequence == null || (n4 = CharSequenceUtils.lastIndexOf(str, charSequence, str.length())) <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        String string = str;
        return string.substring(string.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return EMPTY;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        int n2 = pos;
        return str.substring(n2, n2 + len);
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int n2 = str.indexOf(separator);
        if (n2 == -1) {
            return str;
        }
        return str.substring(0, n2);
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int n2 = str.indexOf(separator);
        if (n2 == -1) {
            return EMPTY;
        }
        return str.substring(n2 + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int n2 = str.lastIndexOf(separator);
        if (n2 == -1) {
            return str;
        }
        return str.substring(0, n2);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int n2 = str.lastIndexOf(separator);
        if (n2 == -1 || n2 == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(n2 + separator.length());
    }

    public static String substringBetween(String str, String tag) {
        String string = tag;
        return StringUtils.substringBetween(str, string, string);
    }

    public static String substringBetween(String str, String open, String close) {
        int n2;
        if (str == null || open == null || close == null) {
            return null;
        }
        int n3 = str.indexOf(open);
        if (n3 != -1 && (n2 = str.indexOf(close, n3 + open.length())) != -1) {
            return str.substring(n3 + open.length(), n2);
        }
        return null;
    }

    public static String[] substringsBetween(String str, String open, String close) {
        int n2;
        int n3;
        if (str == null || StringUtils.isEmpty(open) || StringUtils.isEmpty(close)) {
            return null;
        }
        int n4 = str.length();
        if (n4 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int n5 = close.length();
        int n6 = open.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n7 = 0;
        while (n7 < n4 - n5 && (n3 = str.indexOf(open, n7)) >= 0 && (n2 = str.indexOf(close, n3 += n6)) >= 0) {
            arrayList.add(str.substring(n3, n2));
            n7 = n2 + n5;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, false);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return StringUtils.splitWorker(str, separatorChars, max, false);
    }

    public static String[] splitByWholeSeparator(String str, String separator) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, -1, false);
    }

    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, max, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator, int max) {
        return StringUtils.splitByWholeSeparatorWorker(str, separator, max, true);
    }

    private static String[] splitByWholeSeparatorWorker(String str, String separator, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int n2 = str.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return StringUtils.splitWorker(str, null, max, preserveAllTokens);
        }
        int n3 = separator.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            n6 = str.indexOf(separator, n5);
            if (n6 >= 0) {
                if (n6 > n5) {
                    if (++n4 == max) {
                        n6 = n2;
                        arrayList.add(str.substring(n5));
                        continue;
                    }
                    arrayList.add(str.substring(n5, n6));
                    n5 = n6 + n3;
                    continue;
                }
                if (preserveAllTokens) {
                    if (++n4 == max) {
                        n6 = n2;
                        arrayList.add(str.substring(n5));
                    } else {
                        arrayList.add(EMPTY);
                    }
                }
                n5 = n6 + n3;
                continue;
            }
            arrayList.add(str.substring(n5));
            n6 = n2;
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public static String[] splitPreserveAllTokens(String str) {
        return StringUtils.splitWorker(str, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, true);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int n2 = str.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n3 < n2) {
            if (str.charAt(n3) == separatorChar) {
                if (bl || preserveAllTokens) {
                    arrayList.add(str.substring(n4, n3));
                    bl = false;
                    bl2 = true;
                }
                n4 = ++n3;
                continue;
            }
            bl2 = false;
            bl = true;
            ++n3;
        }
        if (bl || preserveAllTokens && bl2) {
            arrayList.add(str.substring(n4, n3));
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars, int max) {
        return StringUtils.splitWorker(str, separatorChars, max, true);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int n2 = str.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (separatorChars == null) {
            while (n4 < n2) {
                if (Character.isWhitespace(str.charAt(n4))) {
                    if (bl || preserveAllTokens) {
                        bl2 = true;
                        if (n3++ == max) {
                            n4 = n2;
                            bl2 = false;
                        }
                        arrayList.add(str.substring(n5, n4));
                        bl = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl2 = false;
                bl = true;
                ++n4;
            }
        } else if (separatorChars.length() == 1) {
            char c2 = separatorChars.charAt(0);
            while (n4 < n2) {
                if (str.charAt(n4) == c2) {
                    if (bl || preserveAllTokens) {
                        bl2 = true;
                        if (n3++ == max) {
                            n4 = n2;
                            bl2 = false;
                        }
                        arrayList.add(str.substring(n5, n4));
                        bl = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl2 = false;
                bl = true;
                ++n4;
            }
        } else {
            while (n4 < n2) {
                if (separatorChars.indexOf(str.charAt(n4)) >= 0) {
                    if (bl || preserveAllTokens) {
                        bl2 = true;
                        if (n3++ == max) {
                            n4 = n2;
                            bl2 = false;
                        }
                        arrayList.add(str.substring(n5, n4));
                        bl = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl2 = false;
                bl = true;
                ++n4;
            }
        }
        if (bl || preserveAllTokens && bl2) {
            arrayList.add(str.substring(n5, n4));
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public static String[] splitByCharacterType(String str) {
        return StringUtils.splitByCharacterType(str, false);
    }

    public static String[] splitByCharacterTypeCamelCase(String str) {
        return StringUtils.splitByCharacterType(str, true);
    }

    private static String[] splitByCharacterType(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        char[] cArray = str.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = Character.getType(cArray[0]);
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            int n4 = Character.getType(cArray[i2]);
            if (n4 == n3) continue;
            if (camelCase && n4 == 2 && n3 == 1) {
                int n5 = i2 - 1;
                if (n5 != n2) {
                    arrayList.add(new String(cArray, n2, n5 - n2));
                    n2 = n5;
                }
            } else {
                arrayList.add(new String(cArray, n2, i2 - n2));
                n2 = i2;
            }
            n3 = n4;
        }
        arrayList.add(new String(cArray, n2, cArray.length - n2));
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        return StringUtils.join((Object[])elements, null);
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(long[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(int[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(short[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(byte[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(char[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(float[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(double[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            if (array[i2] == null) continue;
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(long[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(int[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(byte[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(short[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(char[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(double[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(float[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int n2;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((n2 = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 4);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                stringBuilder.append(separator);
            }
            if (array[i2] == null) continue;
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(Iterator<?> iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            String string = Objects.toString(obj, EMPTY);
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            stringBuilder.append(separator);
            Object obj2 = iterator.next();
            if (obj2 == null) continue;
            stringBuilder.append(obj2);
        }
        return stringBuilder.toString();
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            String string = Objects.toString(obj, EMPTY);
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            Object obj2;
            if (separator != null) {
                stringBuilder.append(separator);
            }
            if ((obj2 = iterator.next()) == null) continue;
            stringBuilder.append(obj2);
        }
        return stringBuilder.toString();
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), separator);
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), separator);
    }

    public static String joinWith(String separator, Object ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Object varargs must not be null");
        }
        String string = StringUtils.defaultString(separator, EMPTY);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Object> iterator = Arrays.asList(objects).iterator();
        while (iterator.hasNext()) {
            String string2 = Objects.toString(iterator.next(), EMPTY);
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String deleteWhitespace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int n2 = str.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            cArray[n3++] = str.charAt(i2);
        }
        if (n3 == n2) {
            return str;
        }
        return new String(cArray, 0, n3);
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeStartIgnoreCase(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (StringUtils.startsWithIgnoreCase(str, remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String removeEndIgnoreCase(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (StringUtils.endsWithIgnoreCase(str, remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String remove(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replace(str, remove, EMPTY, -1);
    }

    public static String removeIgnoreCase(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replaceIgnoreCase(str, remove, EMPTY, -1);
    }

    public static String remove(String str, char remove) {
        if (StringUtils.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        char[] cArray = str.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == remove) continue;
            cArray[n2++] = cArray[i2];
        }
        return new String(cArray, 0, n2);
    }

    public static String removeAll(String text, String regex) {
        return StringUtils.replaceAll(text, regex, EMPTY);
    }

    public static String removeFirst(String text, String regex) {
        return StringUtils.replaceFirst(text, regex, EMPTY);
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, 1);
    }

    public static String replaceOnceIgnoreCase(String text, String searchString, String replacement) {
        return StringUtils.replaceIgnoreCase(text, searchString, replacement, 1);
    }

    public static String replacePattern(String source, String regex, String replacement) {
        if (source == null || regex == null || replacement == null) {
            return source;
        }
        return Pattern.compile(regex, 32).matcher(source).replaceAll(replacement);
    }

    public static String removePattern(String source, String regex) {
        return StringUtils.replacePattern(source, regex, EMPTY);
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String replaceFirst(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceFirst(regex, replacement);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        return StringUtils.replaceIgnoreCase(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        String string = text;
        if (ignoreCase) {
            string = text.toLowerCase();
            searchString = searchString.toLowerCase();
        }
        int n2 = 0;
        int n3 = string.indexOf(searchString, 0);
        if (n3 == -1) {
            return text;
        }
        int n4 = searchString.length();
        int n5 = replacement.length() - n4;
        n5 = n5 < 0 ? 0 : n5;
        n5 = n5 * (max < 0 ? 16 : (max > 64 ? 64 : max));
        StringBuilder stringBuilder = new StringBuilder(text.length() + n5);
        while (n3 != -1) {
            stringBuilder.append(text.substring(n2, n3)).append(replacement);
            n2 = n3 + n4;
            if (--max == 0) break;
            n3 = string.indexOf(searchString, n2);
        }
        stringBuilder.append(text.substring(n2));
        return stringBuilder.toString();
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, true);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int n2 = searchList == null ? 0 : searchList.length;
        return StringUtils.replaceEach(text, searchList, replacementList, true, n2);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        while (text != null && !text.isEmpty() && searchList != null && searchList.length != 0 && replacementList != null && replacementList.length != 0) {
            int n2;
            int n3;
            int n4;
            if (timeToLive < 0) {
                throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
            }
            int n5 = searchList.length;
            int n6 = replacementList.length;
            if (n5 != n6) {
                throw new IllegalArgumentException("Search and Replace array lengths don't match: " + n5 + " vs " + n6);
            }
            boolean[] blArray = new boolean[n5];
            int n7 = -1;
            int n8 = -1;
            for (n4 = 0; n4 < n5; ++n4) {
                if (blArray[n4] || searchList[n4] == null || searchList[n4].isEmpty() || replacementList[n4] == null) continue;
                n3 = text.indexOf(searchList[n4]);
                if (n3 == -1) {
                    blArray[n4] = true;
                    continue;
                }
                if (n7 != -1 && n3 >= n7) continue;
                n7 = n3;
                n8 = n4;
            }
            if (n7 == -1) {
                return text;
            }
            n4 = 0;
            int n9 = 0;
            for (int i2 = 0; i2 < searchList.length; ++i2) {
                if (searchList[i2] == null || replacementList[i2] == null || (n2 = replacementList[i2].length() - searchList[i2].length()) <= 0) continue;
                n9 += 3 * n2;
            }
            n9 = Math.min(n9, text.length() / 5);
            StringBuilder stringBuilder = new StringBuilder(text.length() + n9);
            while (n7 != -1) {
                for (n2 = n4; n2 < n7; ++n2) {
                    stringBuilder.append(text.charAt(n2));
                }
                stringBuilder.append(replacementList[n8]);
                n4 = n7 + searchList[n8].length();
                n7 = -1;
                n8 = -1;
                for (n2 = 0; n2 < n5; ++n2) {
                    if (blArray[n2] || searchList[n2] == null || searchList[n2].isEmpty() || replacementList[n2] == null) continue;
                    n3 = text.indexOf(searchList[n2], n4);
                    if (n3 == -1) {
                        blArray[n2] = true;
                        continue;
                    }
                    if (n7 != -1 && n3 >= n7) continue;
                    n7 = n3;
                    n8 = n2;
                }
            }
            n2 = text.length();
            for (int i3 = n4; i3 < n2; ++i3) {
                stringBuilder.append(text.charAt(i3));
            }
            String string = stringBuilder.toString();
            if (!repeat) {
                return string;
            }
            --timeToLive;
            text = string;
        }
        return text;
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean bl = false;
        int n2 = replaceChars.length();
        int n3 = str.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = str.charAt(i2);
            int n4 = searchChars.indexOf(c2);
            if (n4 >= 0) {
                bl = true;
                if (n4 >= n2) continue;
                stringBuilder.append(replaceChars.charAt(n4));
                continue;
            }
            stringBuilder.append(c2);
        }
        if (bl) {
            return stringBuilder.toString();
        }
        return str;
    }

    public static String overlay(String str, String overlay, int start, int end) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int n2 = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > n2) {
            start = n2;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > n2) {
            end = n2;
        }
        if (start > end) {
            int n3 = start;
            start = end;
            end = n3;
        }
        return new StringBuilder(n2 + start - end + overlay.length() + 1).append(str.substring(0, start)).append(overlay).append(str.substring(end)).toString();
    }

    public static String chomp(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char c2 = str.charAt(0);
            if (c2 == '\r' || c2 == '\n') {
                return EMPTY;
            }
            return str;
        }
        int n2 = str.length() - 1;
        char c3 = str.charAt(n2);
        if (c3 == '\n') {
            if (str.charAt(n2 - 1) == '\r') {
                --n2;
            }
        } else if (c3 != '\r') {
            ++n2;
        }
        return str.substring(0, n2);
    }

    @Deprecated
    public static String chomp(String str, String separator) {
        return StringUtils.removeEnd(str, separator);
    }

    public static String chop(String str) {
        if (str == null) {
            return null;
        }
        int n2 = str.length();
        if (n2 < 2) {
            return EMPTY;
        }
        int n3 = n2 - 1;
        String string = str.substring(0, n3);
        char c2 = str.charAt(n3);
        if (c2 == '\n' && string.charAt(n3 - 1) == '\r') {
            return string.substring(0, n3 - 1);
        }
        return string;
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int n2 = str.length();
        if (repeat == 1 || n2 == 0) {
            return str;
        }
        if (n2 == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int n3 = n2 * repeat;
        switch (n2) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char c2 = str.charAt(0);
                char c3 = str.charAt(1);
                char[] cArray = new char[n3];
                for (int i2 = (repeat << 1) - 2; i2 >= 0; --i2) {
                    cArray[i2] = c2;
                    cArray[i2 + 1] = c3;
                    --i2;
                }
                return new String(cArray);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i3 = 0; i3 < repeat; ++i3) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String str, String separator, int repeat) {
        if (str == null || separator == null) {
            return StringUtils.repeat(str, repeat);
        }
        String string = StringUtils.repeat(str + separator, repeat);
        return StringUtils.removeEnd(string, separator);
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        char[] cArray = new char[repeat];
        for (int i2 = repeat - 1; i2 >= 0; --i2) {
            cArray[i2] = ch;
        }
        return new String(cArray);
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int n2 = size - str.length();
        if (n2 <= 0) {
            return str;
        }
        if (n2 > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.repeat(padChar, n2));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int n2 = padStr.length();
        int n3 = str.length();
        int n4 = size - n3;
        if (n4 <= 0) {
            return str;
        }
        if (n2 == 1 && n4 <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (n4 == n2) {
            return str.concat(padStr);
        }
        if (n4 < n2) {
            return str.concat(padStr.substring(0, n4));
        }
        char[] cArray = new char[n4];
        char[] cArray2 = padStr.toCharArray();
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[i2] = cArray2[i2 % n2];
        }
        return str.concat(new String(cArray));
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int n2 = size - str.length();
        if (n2 <= 0) {
            return str;
        }
        if (n2 > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.repeat(padChar, n2).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int n2 = padStr.length();
        int n3 = str.length();
        int n4 = size - n3;
        if (n4 <= 0) {
            return str;
        }
        if (n2 == 1 && n4 <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (n4 == n2) {
            return padStr.concat(str);
        }
        if (n4 < n2) {
            return padStr.substring(0, n4).concat(str);
        }
        char[] cArray = new char[n4];
        char[] cArray2 = padStr.toCharArray();
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[i2] = cArray2[i2 % n2];
        }
        return new String(cArray).concat(str);
    }

    public static int length(CharSequence cs) {
        if (cs == null) {
            return 0;
        }
        return cs.length();
    }

    public static String center(String str, int size) {
        return StringUtils.center(str, size, ' ');
    }

    public static String center(String str, int size, char padChar) {
        if (str == null || size <= 0) {
            return str;
        }
        int n2 = str.length();
        int n3 = size - n2;
        if (n3 <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, n2 + n3 / 2, padChar);
        str = StringUtils.rightPad(str, size, padChar);
        return str;
    }

    public static String center(String str, int size, String padStr) {
        int n2;
        int n3;
        if (str == null || size <= 0) {
            return str;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((n3 = size - (n2 = str.length())) <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, n2 + n3 / 2, padStr);
        str = StringUtils.rightPad(str, size, padStr);
        return str;
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String upperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(locale);
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String lowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(locale);
    }

    public static String capitalize(String str) {
        int n2;
        int n3;
        int n4;
        if (str == null || (n4 = str.length()) == 0) {
            return str;
        }
        int n5 = str.codePointAt(0);
        if (n5 == (n3 = Character.toTitleCase(n5))) {
            return str;
        }
        int[] nArray = new int[n4];
        int n6 = 0;
        ++n6;
        nArray[0] = n3;
        for (int i2 = Character.charCount(n5); i2 < n4; i2 += Character.charCount(n2)) {
            n2 = str.codePointAt(i2);
            nArray[n6++] = n2;
        }
        return new String(nArray, 0, n6);
    }

    public static String uncapitalize(String str) {
        int n2;
        int n3;
        int n4;
        if (str == null || (n4 = str.length()) == 0) {
            return str;
        }
        int n5 = str.codePointAt(0);
        if (n5 == (n3 = Character.toLowerCase(n5))) {
            return str;
        }
        int[] nArray = new int[n4];
        int n6 = 0;
        ++n6;
        nArray[0] = n3;
        for (int i2 = Character.charCount(n5); i2 < n4; i2 += Character.charCount(n2)) {
            n2 = str.codePointAt(i2);
            nArray[n6++] = n2;
        }
        return new String(nArray, 0, n6);
    }

    public static String swapCase(String str) {
        int n2;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int n3 = str.length();
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            int n5 = str.codePointAt(i2);
            n2 = Character.isUpperCase(n5) ? Character.toLowerCase(n5) : (Character.isTitleCase(n5) ? Character.toLowerCase(n5) : (Character.isLowerCase(n5) ? Character.toUpperCase(n5) : n5));
            nArray[n4++] = n2;
        }
        return new String(nArray, 0, n4);
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = CharSequenceUtils.indexOf(str, sub, n3)) != -1) {
            ++n2;
            n3 += sub.length();
        }
        return n2;
    }

    public static int countMatches(CharSequence str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (ch != str.charAt(i2)) continue;
            ++n2;
        }
        return n2;
    }

    public static boolean isAlpha(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(cs.charAt(i2)) || cs.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(cs.charAt(i2)) || cs.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (CharUtils.isAsciiPrintable(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(cs.charAt(i2)) || cs.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static String getDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int n2 = str.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            if (!Character.isDigit(c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static boolean isWhitespace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (cs == null || StringUtils.isEmpty(cs)) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLowerCase(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (cs == null || StringUtils.isEmpty(cs)) {
            return false;
        }
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isUpperCase(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isMixedCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs) || cs.length() == 1) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = cs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl && bl2) {
                return true;
            }
            if (Character.isUpperCase(cs.charAt(i2))) {
                bl = true;
                continue;
            }
            if (!Character.isLowerCase(cs.charAt(i2))) continue;
            bl2 = true;
        }
        return bl && bl2;
    }

    public static String defaultString(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    public static String defaultString(String str, String defaultStr) {
        if (str == null) {
            return defaultStr;
        }
        return str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        if (StringUtils.isBlank(str)) {
            return defaultStr;
        }
        return str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        if (StringUtils.isEmpty(str)) {
            return defaultStr;
        }
        return str;
    }

    public static String rotate(String str, int shift) {
        if (str == null) {
            return null;
        }
        int n2 = str.length();
        if (shift == 0 || n2 == 0 || shift % n2 == 0) {
            return str;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = -(shift % n2);
        stringBuilder.append(StringUtils.substring(str, n3));
        stringBuilder.append(StringUtils.substring(str, 0, n3));
        return stringBuilder.toString();
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String reverseDelimited(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(str, separatorChar);
        ArrayUtils.reverse(objectArray);
        return StringUtils.join(objectArray, separatorChar);
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate(str, "...", 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        return StringUtils.abbreviate(str, "...", offset, maxWidth);
    }

    public static String abbreviate(String str, String abbrevMarker, int maxWidth) {
        return StringUtils.abbreviate(str, abbrevMarker, 0, maxWidth);
    }

    public static String abbreviate(String str, String abbrevMarker, int offset, int maxWidth) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(abbrevMarker)) {
            return str;
        }
        int n2 = abbrevMarker.length();
        int n3 = n2 + 1;
        int n4 = n2;
        int n5 = n4 + n4 + 1;
        if (maxWidth < n3) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width is %d", n3));
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - n2) {
            offset = str.length() - (maxWidth - n2);
        }
        if (offset <= n3) {
            return str.substring(0, maxWidth - n2) + abbrevMarker;
        }
        if (maxWidth < n5) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width with offset is %d", n5));
        }
        if (offset + maxWidth - n2 < str.length()) {
            return abbrevMarker + StringUtils.abbreviate(str.substring(offset), abbrevMarker, maxWidth - n2);
        }
        String string = str;
        return abbrevMarker + string.substring(string.length() - (maxWidth - n2));
    }

    public static String abbreviateMiddle(String str, String middle, int length) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(middle)) {
            return str;
        }
        if (length >= str.length() || length < middle.length() + 2) {
            return str;
        }
        int n2 = length - middle.length();
        int n3 = n2 / 2 + n2 % 2;
        int n4 = str.length() - n2 / 2;
        StringBuilder stringBuilder = new StringBuilder(length);
        stringBuilder.append(str.substring(0, n3));
        stringBuilder.append(middle);
        stringBuilder.append(str.substring(n4));
        return stringBuilder.toString();
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int n2 = StringUtils.indexOfDifference((CharSequence)str1, (CharSequence)str2);
        if (n2 == -1) {
            return EMPTY;
        }
        return str2.substring(n2);
    }

    public static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        int n2;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (n2 = 0; n2 < cs1.length() && n2 < cs2.length() && cs1.charAt(n2) == cs2.charAt(n2); ++n2) {
        }
        if (n2 < cs2.length() || n2 < cs1.length()) {
            return n2;
        }
        return -1;
    }

    public static int indexOfDifference(CharSequence ... css) {
        int n2;
        if (css == null || css.length <= 1) {
            return -1;
        }
        boolean bl = false;
        boolean bl2 = true;
        int n3 = css.length;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        CharSequence[] charSequenceArray = css;
        int n6 = css.length;
        for (n2 = 0; n2 < n6; ++n2) {
            CharSequence charSequence = charSequenceArray[n2];
            if (charSequence == null) {
                bl = true;
                n4 = 0;
                continue;
            }
            bl2 = false;
            n4 = Math.min(charSequence.length(), n4);
            n5 = Math.max(charSequence.length(), n5);
        }
        if (bl2 || n5 == 0 && !bl) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        int n7 = -1;
        for (n6 = 0; n6 < n4; ++n6) {
            n2 = css[0].charAt(n6);
            for (int i2 = 1; i2 < n3; ++i2) {
                if (css[i2].charAt(n6) == n2) continue;
                n7 = n6;
                break;
            }
            if (n7 != -1) break;
        }
        if (n7 == -1 && n4 != n5) {
            return n4;
        }
        return n7;
    }

    public static String getCommonPrefix(String ... strs) {
        if (strs == null || strs.length == 0) {
            return EMPTY;
        }
        int n2 = StringUtils.indexOfDifference(strs);
        if (n2 == -1) {
            if (strs[0] == null) {
                return EMPTY;
            }
            return strs[0];
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return strs[0].substring(0, n2);
    }

    @Deprecated
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t2) {
        Object object;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = s2.length();
        int n3 = t2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            object = s2;
            s2 = t2;
            t2 = object;
            n2 = n3;
            n3 = t2.length();
        }
        object = new int[n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            object[n5] = n5;
        }
        for (int i2 = 1; i2 <= n3; ++i2) {
            Object object2 = object[0];
            char c2 = t2.charAt(i2 - 1);
            object[0] = i2;
            for (n4 = 1; n4 <= n2; ++n4) {
                Object object3 = object[n4];
                boolean bl = s2.charAt(n4 - 1) != c2;
                object[n4] = Math.min(Math.min((int)(object[n4 - 1] + true), (int)(object[n4] + true)), (int)(object2 + bl));
                object2 = object3;
            }
        }
        return (int)object[n2];
    }

    @Deprecated
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t2, int threshold) {
        Object object;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = s2.length();
        int n3 = t2.length();
        if (n2 == 0) {
            if (n3 <= threshold) {
                return n3;
            }
            return -1;
        }
        if (n3 == 0) {
            if (n2 <= threshold) {
                return n2;
            }
            return -1;
        }
        if (Math.abs(n2 - n3) > threshold) {
            return -1;
        }
        if (n2 > n3) {
            object = s2;
            s2 = t2;
            t2 = object;
            n2 = n3;
            n3 = t2.length();
        }
        object = new int[n2 + 1];
        Object object2 = new int[n2 + 1];
        int n4 = Math.min(n2, threshold) + 1;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5++;
            object[n6] = n6;
        }
        Arrays.fill((int[])object, n4, ((Object)object).length, Integer.MAX_VALUE);
        Arrays.fill(object2, Integer.MAX_VALUE);
        for (n5 = 1; n5 <= n3; ++n5) {
            int n7;
            char c2 = t2.charAt(n5 - 1);
            object2[0] = n5;
            int n8 = Math.max(1, n5 - threshold);
            int n9 = n7 = n5 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, n5 + threshold);
            if (n8 > n7) {
                return -1;
            }
            if (n8 > 1) {
                object2[n8 - 1] = Integer.MAX_VALUE;
            }
            for (int i2 = n8; i2 <= n7; ++i2) {
                object2[i2] = s2.charAt(i2 - 1) == c2 ? (int)object[i2 - 1] : 1 + Math.min(Math.min(object2[i2 - 1], (int)object[i2]), (int)object[i2 - 1]);
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        if (object[n2] <= threshold) {
            return (int)object[n2];
        }
        return -1;
    }

    @Deprecated
    public static double getJaroWinklerDistance(CharSequence first, CharSequence second) {
        double d2;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int[] nArray = StringUtils.matches(first, second);
        double d3 = nArray[0];
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = (d3 / (double)first.length() + d3 / (double)second.length() + (d3 - (double)nArray[1]) / d3) / 3.0;
        double d5 = d2 < 0.7 ? d4 : d4 + Math.min(0.1, 1.0 / (double)nArray[3]) * (double)nArray[2] * (1.0 - d4);
        return (double)Math.round(d5 * 100.0) / 100.0;
    }

    private static int[] matches(CharSequence first, CharSequence second) {
        int n2;
        int n3;
        CharSequence charSequence;
        CharSequence charSequence2;
        if (first.length() > second.length()) {
            charSequence2 = first;
            charSequence = second;
        } else {
            charSequence2 = second;
            charSequence = first;
        }
        int n4 = Math.max(charSequence2.length() / 2 - 1, 0);
        int[] nArray = new int[charSequence.length()];
        Arrays.fill(nArray, -1);
        boolean[] blArray = new boolean[charSequence2.length()];
        int n5 = 0;
        block0: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            n3 = Math.min(i2 + n4 + 1, charSequence2.length());
            for (n2 = Math.max(i2 - n4, 0); n2 < n3; ++n2) {
                if (blArray[n2] || c2 != charSequence2.charAt(n2)) continue;
                nArray[i2] = n2;
                blArray[n2] = true;
                ++n5;
                continue block0;
            }
        }
        char[] cArray = new char[n5];
        char[] cArray2 = new char[n5];
        n3 = 0;
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            if (nArray[n2] == -1) continue;
            cArray[n3] = charSequence.charAt(n2);
            ++n3;
        }
        n3 = 0;
        for (n2 = 0; n2 < charSequence2.length(); ++n2) {
            if (!blArray[n2]) continue;
            cArray2[n3] = charSequence2.charAt(n2);
            ++n3;
        }
        n2 = 0;
        for (n3 = 0; n3 < cArray.length; ++n3) {
            if (cArray[n3] == cArray2[n3]) continue;
            ++n2;
        }
        n3 = 0;
        for (int i3 = 0; i3 < charSequence.length() && first.charAt(i3) == second.charAt(i3); ++i3) {
            ++n3;
        }
        return new int[]{n5, n2 / 2, n3, charSequence2.length()};
    }

    @Deprecated
    public static int getFuzzyDistance(CharSequence term, CharSequence query, Locale locale) {
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        String string = term.toString().toLowerCase(locale);
        String string2 = query.toString().toLowerCase(locale);
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            boolean bl = false;
            while (n3 < string.length() && !bl) {
                char c3 = string.charAt(n3);
                if (c2 == c3) {
                    ++n2;
                    if (n4 + 1 == n3) {
                        n2 += 2;
                    }
                    n4 = n3;
                    bl = true;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, false);
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, true);
    }

    private static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(str, ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        CharSequence[] charSequenceArray = searchStrings;
        int n2 = searchStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.startsWith(sequence, charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith(str, suffix, true);
    }

    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int n2 = str.length() - suffix.length();
        return CharSequenceUtils.regionMatches(str, ignoreCase, n2, suffix, 0, suffix.length());
    }

    public static String normalizeSpace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int n2 = str.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            boolean bl2 = Character.isWhitespace(c2);
            if (!bl2) {
                bl = false;
                cArray[n3++] = c2 == '\u00a0' ? 32 : (int)c2;
                n4 = 0;
                continue;
            }
            if (n4 == 0 && !bl) {
                cArray[n3++] = SPACE.charAt(0);
            }
            ++n4;
        }
        if (bl) {
            return EMPTY;
        }
        return new String(cArray, 0, n3 - (n4 > 0 ? 1 : 0)).trim();
    }

    public static boolean endsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        CharSequence[] charSequenceArray = searchStrings;
        int n2 = searchStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (!StringUtils.endsWith(sequence, charSequence)) continue;
            return true;
        }
        return false;
    }

    private static String appendIfMissing(String str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (str == null || StringUtils.isEmpty(suffix) || StringUtils.endsWith(str, suffix, ignoreCase)) {
            return str;
        }
        if (suffixes != null && suffixes.length > 0) {
            CharSequence[] charSequenceArray = suffixes;
            int n2 = suffixes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CharSequence charSequence = charSequenceArray[i2];
                if (!StringUtils.endsWith(str, charSequence, ignoreCase)) continue;
                return str;
            }
        }
        return str + suffix.toString();
    }

    public static String appendIfMissing(String str, CharSequence suffix, CharSequence ... suffixes) {
        return StringUtils.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(String str, CharSequence suffix, CharSequence ... suffixes) {
        return StringUtils.appendIfMissing(str, suffix, true, suffixes);
    }

    private static String prependIfMissing(String str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || StringUtils.isEmpty(prefix) || StringUtils.startsWith(str, prefix, ignoreCase)) {
            return str;
        }
        if (prefixes != null && prefixes.length > 0) {
            CharSequence[] charSequenceArray = prefixes;
            int n2 = prefixes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CharSequence charSequence = charSequenceArray[i2];
                if (!StringUtils.startsWith(str, charSequence, ignoreCase)) continue;
                return str;
            }
        }
        return prefix.toString() + str;
    }

    public static String prependIfMissing(String str, CharSequence prefix, CharSequence ... prefixes) {
        return StringUtils.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(String str, CharSequence prefix, CharSequence ... prefixes) {
        return StringUtils.prependIfMissing(str, prefix, true, prefixes);
    }

    @Deprecated
    public static String toString(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        if (charsetName != null) {
            return new String(bytes, charsetName);
        }
        return new String(bytes, Charset.defaultCharset());
    }

    public static String toEncodedString(byte[] bytes, Charset charset) {
        return new String(bytes, charset != null ? charset : Charset.defaultCharset());
    }

    public static String wrap(String str, char wrapWith) {
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        return wrapWith + str + wrapWith;
    }

    public static String wrap(String str, String wrapWith) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        return wrapWith.concat(str).concat(wrapWith);
    }

    public static String wrapIfMissing(String str, char wrapWith) {
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        StringBuilder stringBuilder = new StringBuilder(str.length() + 2);
        if (str.charAt(0) != wrapWith) {
            stringBuilder.append(wrapWith);
        }
        stringBuilder.append(str);
        String string = str;
        if (string.charAt(string.length() - 1) != wrapWith) {
            stringBuilder.append(wrapWith);
        }
        return stringBuilder.toString();
    }

    public static String wrapIfMissing(String str, String wrapWith) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        StringBuilder stringBuilder = new StringBuilder(str.length() + wrapWith.length() + wrapWith.length());
        if (!str.startsWith(wrapWith)) {
            stringBuilder.append(wrapWith);
        }
        stringBuilder.append(str);
        if (!str.endsWith(wrapWith)) {
            stringBuilder.append(wrapWith);
        }
        return stringBuilder.toString();
    }

    public static String unwrap(String str, String wrapToken) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapToken)) {
            return str;
        }
        if (StringUtils.startsWith(str, wrapToken) && StringUtils.endsWith(str, wrapToken)) {
            int n2 = str.indexOf(wrapToken);
            int n3 = str.lastIndexOf(wrapToken);
            int n4 = wrapToken.length();
            if (n2 != -1 && n3 != -1) {
                return str.substring(n2 + n4, n3);
            }
        }
        return str;
    }

    public static String unwrap(String str, char wrapChar) {
        if (StringUtils.isEmpty(str) || wrapChar == '\u0000') {
            return str;
        }
        if (str.charAt(0) == wrapChar) {
            int n2;
            String string = str;
            if (string.charAt(string.length() - 1) == wrapChar && (n2 = str.length() - 1) != -1) {
                return str.substring(1, n2);
            }
        }
        return str;
    }

    public static int[] toCodePoints(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        String string = str.toString();
        int[] nArray = new int[string.codePointCount(0, string.length())];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.codePointAt(n2);
            n2 += Character.charCount(nArray[i2]);
        }
        return nArray;
    }
}

