/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.EqualsExclude;
import org.apache.commons.lang3.builder.IDKey;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class EqualsBuilder
implements Builder<Boolean> {
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> REGISTRY = new ThreadLocal();
    private boolean isEquals = true;
    private boolean testTransients = false;
    private boolean testRecursive = false;
    private Class<?> reflectUpToClass = null;
    private String[] excludeFields = null;

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return REGISTRY.get();
    }

    static Pair<IDKey, IDKey> getRegisterPair(Object lhs, Object rhs) {
        IDKey iDKey = new IDKey(lhs);
        IDKey iDKey2 = new IDKey(rhs);
        return Pair.of(iDKey, iDKey2);
    }

    static boolean isRegistered(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(lhs, rhs);
        Pair<IDKey, IDKey> pair2 = Pair.of(pair.getLeft(), pair.getRight());
        return set != null && (set.contains(pair) || set.contains(pair2));
    }

    private static void register(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        if (set == null) {
            set = new HashSet<Pair<IDKey, IDKey>>();
            REGISTRY.set(set);
        }
        Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(lhs, rhs);
        set.add(pair);
    }

    private static void unregister(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        if (set != null) {
            Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(lhs, rhs);
            set.remove(pair);
            if (set.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public EqualsBuilder setTestTransients(boolean testTransients) {
        this.testTransients = testTransients;
        return this;
    }

    public EqualsBuilder setTestRecursive(boolean testRecursive) {
        this.testRecursive = testRecursive;
        return this;
    }

    public EqualsBuilder setReflectUpToClass(Class<?> reflectUpToClass) {
        this.reflectUpToClass = reflectUpToClass;
        return this;
    }

    public EqualsBuilder setExcludeFields(String ... excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, Collection<String> excludeFields) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, ReflectionToStringBuilder.toNoNullStringArray(excludeFields));
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, String ... excludeFields) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, false, null, excludeFields);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, testTransients, null, new String[0]);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, testTransients, reflectUpToClass, false, excludeFields);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class<?> reflectUpToClass, boolean testRecursive, String ... excludeFields) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return new EqualsBuilder().setExcludeFields(excludeFields).setReflectUpToClass(reflectUpToClass).setTestTransients(testTransients).setTestRecursive(testRecursive).reflectionAppend(lhs, rhs).isEquals();
    }

    public EqualsBuilder reflectionAppend(Object lhs, Object rhs) {
        block14: {
            Class<?> clazz;
            if (!this.isEquals) {
                return this;
            }
            if (lhs == rhs) {
                return this;
            }
            if (lhs == null || rhs == null) {
                this.isEquals = false;
                return this;
            }
            Class<?> clazz2 = lhs.getClass();
            Class<?> clazz3 = rhs.getClass();
            if (clazz2.isInstance(rhs)) {
                clazz = clazz2;
                if (!clazz3.isInstance(lhs)) {
                    clazz = clazz3;
                }
            } else if (clazz3.isInstance(lhs)) {
                clazz = clazz3;
                if (!clazz2.isInstance(rhs)) {
                    clazz = clazz2;
                }
            } else {
                this.isEquals = false;
                return this;
            }
            try {
                if (clazz.isArray()) {
                    this.append(lhs, rhs);
                    break block14;
                }
                while (true) {
                    this.reflectionAppend(lhs, rhs, clazz);
                    if (clazz.getSuperclass() != null && clazz != this.reflectUpToClass) {
                        clazz = clazz.getSuperclass();
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.isEquals = false;
                return this;
            }
        }
        return this;
    }

    private void reflectionAppend(Object lhs, Object rhs, Class<?> clazz) {
        if (EqualsBuilder.isRegistered(lhs, rhs)) {
            return;
        }
        try {
            EqualsBuilder.register(lhs, rhs);
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            for (int i2 = 0; i2 < accessibleObjectArray.length && this.isEquals; ++i2) {
                AccessibleObject accessibleObject = accessibleObjectArray[i2];
                if (ArrayUtils.contains(this.excludeFields, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().contains("$") || !this.testTransients && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers()) || accessibleObject.isAnnotationPresent(EqualsExclude.class)) continue;
                try {
                    this.append(((Field)accessibleObject).get(lhs), ((Field)accessibleObject).get(rhs));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            return;
        }
        finally {
            EqualsBuilder.unregister(lhs, rhs);
        }
    }

    public EqualsBuilder appendSuper(boolean superEquals) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = superEquals;
        return this;
    }

    public EqualsBuilder append(Object lhs, Object rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        Class<?> clazz = lhs.getClass();
        if (!clazz.isArray()) {
            if (this.testRecursive && !ClassUtils.isPrimitiveOrWrapper(clazz)) {
                this.reflectionAppend(lhs, rhs);
            } else {
                this.isEquals = lhs.equals(rhs);
            }
        } else {
            this.appendArray(lhs, rhs);
        }
        return this;
    }

    private void appendArray(Object lhs, Object rhs) {
        if (lhs.getClass() != rhs.getClass()) {
            this.setEquals(false);
            return;
        }
        if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs);
            return;
        }
        if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs);
            return;
        }
        if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs);
            return;
        }
        if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs);
            return;
        }
        if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs);
            return;
        }
        if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs);
            return;
        }
        if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs);
            return;
        }
        if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs);
            return;
        }
        this.append((Object[])lhs, (Object[])rhs);
    }

    public EqualsBuilder append(long lhs, long rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(int lhs, int rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(short lhs, short rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(char lhs, char rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(byte lhs, byte rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(double lhs, double rhs) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Double.doubleToLongBits(lhs), Double.doubleToLongBits(rhs));
    }

    public EqualsBuilder append(float lhs, float rhs) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Float.floatToIntBits(lhs), Float.floatToIntBits(rhs));
    }

    public EqualsBuilder append(boolean lhs, boolean rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(Object[] lhs, Object[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(long[] lhs, long[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(int[] lhs, int[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(short[] lhs, short[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(char[] lhs, char[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(byte[] lhs, byte[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(double[] lhs, double[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(float[] lhs, float[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public EqualsBuilder append(boolean[] lhs, boolean[] rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.isEquals; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public boolean isEquals() {
        return this.isEquals;
    }

    @Override
    public Boolean build() {
        return this.isEquals();
    }

    protected void setEquals(boolean isEquals) {
        this.isEquals = isEquals;
    }

    public void reset() {
        this.isEquals = true;
    }
}

