/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class WordUtils {
    public static String wrap(String str, int wrapLength) {
        return WordUtils.wrap(str, wrapLength, null, false);
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        return WordUtils.wrap(str, wrapLength, newLineStr, wrapLongWords, " ");
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords, String wrapOn) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = System.lineSeparator();
        }
        if (wrapLength <= 0) {
            wrapLength = 1;
        }
        if (StringUtils.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern pattern = Pattern.compile(wrapOn);
        int n2 = str.length();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        while (n3 < n2) {
            int n4 = -1;
            int n5 = n3;
            Matcher matcher = pattern.matcher(str.substring(n5, Math.min(n5 + wrapLength + 1, n2)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    n3 += matcher.end();
                    continue;
                }
                n4 = matcher.start() + n3;
            }
            if (n2 - n3 <= wrapLength) break;
            while (matcher.find()) {
                n4 = matcher.start() + n3;
            }
            if (n4 >= n3) {
                stringBuilder.append(str.substring(n3, n4));
                stringBuilder.append(newLineStr);
                n3 = n4 + 1;
                continue;
            }
            if (wrapLongWords) {
                stringBuilder.append(str.substring(n3, wrapLength + n3));
                stringBuilder.append(newLineStr);
                n3 += wrapLength;
                continue;
            }
            matcher = pattern.matcher(str.substring(n3 + wrapLength));
            if (matcher.find()) {
                n4 = matcher.start() + n3 + wrapLength;
            }
            if (n4 >= 0) {
                stringBuilder.append(str.substring(n3, n4));
                stringBuilder.append(newLineStr);
                n3 = n4 + 1;
                continue;
            }
            stringBuilder.append(str.substring(n3));
            n3 = n2;
        }
        stringBuilder.append(str.substring(n3));
        return stringBuilder.toString();
    }

    public static String capitalize(String str) {
        return WordUtils.capitalize(str, null);
    }

    public static String capitalize(String str, char ... delimiters) {
        int n2;
        int n3 = n2 = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || n2 == 0) {
            return str;
        }
        char[] cArray = str.toCharArray();
        boolean bl = true;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (WordUtils.isDelimiter(c2, delimiters)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            cArray[i2] = Character.toTitleCase(c2);
            bl = false;
        }
        return new String(cArray);
    }

    public static String capitalizeFully(String str) {
        return WordUtils.capitalizeFully(str, null);
    }

    public static String capitalizeFully(String str, char ... delimiters) {
        int n2;
        int n3 = n2 = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || n2 == 0) {
            return str;
        }
        str = str.toLowerCase();
        return WordUtils.capitalize(str, delimiters);
    }

    public static String uncapitalize(String str) {
        return WordUtils.uncapitalize(str, null);
    }

    public static String uncapitalize(String str, char ... delimiters) {
        int n2;
        int n3 = n2 = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || n2 == 0) {
            return str;
        }
        char[] cArray = str.toCharArray();
        boolean bl = true;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (WordUtils.isDelimiter(c2, delimiters)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            cArray[i2] = Character.toLowerCase(c2);
            bl = false;
        }
        return new String(cArray);
    }

    public static String swapCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] cArray = str.toCharArray();
        boolean bl = true;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (Character.isUpperCase(c2)) {
                cArray[i2] = Character.toLowerCase(c2);
                bl = false;
                continue;
            }
            if (Character.isTitleCase(c2)) {
                cArray[i2] = Character.toLowerCase(c2);
                bl = false;
                continue;
            }
            if (Character.isLowerCase(c2)) {
                if (bl) {
                    cArray[i2] = Character.toTitleCase(c2);
                    bl = false;
                    continue;
                }
                cArray[i2] = Character.toUpperCase(c2);
                continue;
            }
            bl = Character.isWhitespace(c2);
        }
        return new String(cArray);
    }

    public static String initials(String str) {
        return WordUtils.initials(str, null);
    }

    public static String initials(String str, char ... delimiters) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (delimiters != null && delimiters.length == 0) {
            return "";
        }
        int n2 = str.length();
        char[] cArray = new char[n2 / 2 + 1];
        int n3 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            if (WordUtils.isDelimiter(c2, delimiters)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            cArray[n3++] = c2;
            bl = false;
        }
        return new String(cArray, 0, n3);
    }

    public static boolean containsAllWords(CharSequence word, CharSequence ... words) {
        if (StringUtils.isEmpty(word) || ArrayUtils.isEmpty(words)) {
            return false;
        }
        CharSequence[] charSequenceArray = words;
        int n2 = words.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (StringUtils.isBlank(charSequence)) {
                return false;
            }
            Pattern pattern = Pattern.compile(".*\\b" + charSequence + "\\b.*");
            if (pattern.matcher(word).matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        char[] cArray = delimiters;
        int n2 = delimiters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (ch != c2) continue;
            return true;
        }
        return false;
    }
}

