/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long durationMillis, String format) {
        return DurationFormatUtils.formatDuration(durationMillis, format, true);
    }

    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, durationMillis, "durationMillis must not be negative");
        Token[] tokenArray = DurationFormatUtils.lexx(format);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = durationMillis;
        if (Token.containsTokenWithValue(tokenArray, d)) {
            l2 = durationMillis / 86400000L;
            l6 = durationMillis - l2 * 86400000L;
        }
        if (Token.containsTokenWithValue(tokenArray, H)) {
            l3 = l6 / 3600000L;
            l6 -= l3 * 3600000L;
        }
        if (Token.containsTokenWithValue(tokenArray, m)) {
            l4 = l6 / 60000L;
            l6 -= l4 * 60000L;
        }
        if (Token.containsTokenWithValue(tokenArray, s)) {
            l5 = l6 / 1000L;
            l6 -= l5 * 1000L;
        }
        return DurationFormatUtils.format(tokenArray, 0L, 0L, l2, l3, l4, l5, l6, padWithZeros);
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(durationMillis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            string = StringUtils.replaceOnce(string2 = " " + string2, " 0 days", "");
            if (string.length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
                string2 = string;
                string2 = string = StringUtils.replaceOnce(string2, " 0 minutes", "");
                if (string.length() != string2.length()) {
                    string2 = StringUtils.replaceOnce(string, " 0 seconds", "");
                }
            }
            if (string2.length() != 0) {
                string2 = string2.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (string = StringUtils.replaceOnce(string2, " 0 seconds", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 minutes", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
            string2 = StringUtils.replaceOnce(string, " 0 days", "");
        }
        string2 = " " + string2;
        string2 = StringUtils.replaceOnce(string2, " 1 seconds", " 1 second");
        string2 = StringUtils.replaceOnce(string2, " 1 minutes", " 1 minute");
        string2 = StringUtils.replaceOnce(string2, " 1 hours", " 1 hour");
        string2 = StringUtils.replaceOnce(string2, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriodISO(long startMillis, long endMillis) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, format, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format, boolean padWithZeros, TimeZone timezone) {
        Validate.isTrue(startMillis <= endMillis, "startMillis must not be greater than endMillis", new Object[0]);
        Token[] tokenArray = DurationFormatUtils.lexx(format);
        Calendar calendar = Calendar.getInstance(timezone);
        calendar.setTime(new Date(startMillis));
        Calendar calendar2 = Calendar.getInstance(timezone);
        calendar2.setTime(new Date(endMillis));
        int n2 = calendar2.get(14) - calendar.get(14);
        int n3 = calendar2.get(13) - calendar.get(13);
        int n4 = calendar2.get(12) - calendar.get(12);
        int n5 = calendar2.get(11) - calendar.get(11);
        int n6 = calendar2.get(5) - calendar.get(5);
        int n7 = calendar2.get(2) - calendar.get(2);
        int n8 = calendar2.get(1) - calendar.get(1);
        while (n2 < 0) {
            n2 += 1000;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n5;
        }
        while (n5 < 0) {
            n5 += 24;
            --n6;
        }
        if (Token.containsTokenWithValue(tokenArray, M)) {
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
            while (n7 < 0) {
                n7 += 12;
                --n8;
            }
            if (!Token.containsTokenWithValue(tokenArray, y) && n8 != 0) {
                while (n8 != 0) {
                    n7 += n8 * 12;
                    n8 = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokenArray, y)) {
                int n9 = calendar2.get(1);
                if (n7 < 0) {
                    --n9;
                }
                while (calendar.get(1) != n9) {
                    n6 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n6;
                    }
                    calendar.add(1, 1);
                    n6 += calendar.get(6);
                }
                n8 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n6 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n7 = 0;
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokenArray, d)) {
            n5 += n6 * 24;
            n6 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, H)) {
            n4 += n5 * 60;
            n5 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, m)) {
            n3 += n4 * 60;
            n4 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, s)) {
            n2 += n3 * 1000;
            n3 = 0;
        }
        return DurationFormatUtils.format(tokenArray, n8, n7, n6, n5, n4, n3, n2, padWithZeros);
    }

    static String format(Token[] tokens, long years, long months, long days, long hours, long minutes, long seconds, long milliseconds, boolean padWithZeros) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        Token[] tokenArray = tokens;
        int n2 = tokens.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Token token = tokenArray[i2];
            Object object = token.getValue();
            int n3 = token.getCount();
            if (object instanceof StringBuilder) {
                stringBuilder.append(object.toString());
                continue;
            }
            if (object.equals(y)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(years, padWithZeros, n3));
            } else if (object.equals(M)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(months, padWithZeros, n3));
            } else if (object.equals(d)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(days, padWithZeros, n3));
            } else if (object.equals(H)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(hours, padWithZeros, n3));
            } else if (object.equals(m)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(minutes, padWithZeros, n3));
            } else {
                if (object.equals(s)) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(seconds, padWithZeros, n3));
                    bl = true;
                    continue;
                }
                if (!object.equals(S)) continue;
                if (bl) {
                    int n4 = padWithZeros ? Math.max(3, n3) : 3;
                    stringBuilder.append(DurationFormatUtils.paddedValue(milliseconds, true, n4));
                } else {
                    stringBuilder.append(DurationFormatUtils.paddedValue(milliseconds, padWithZeros, n3));
                }
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    private static String paddedValue(long value, boolean padWithZeros, int count) {
        String string = Long.toString(value);
        if (padWithZeros) {
            return StringUtils.leftPad(string, count, '0');
        }
        return string;
    }

    static Token[] lexx(String format) {
        ArrayList<Token> arrayList = new ArrayList<Token>(format.length());
        boolean bl = false;
        StringBuilder stringBuilder = null;
        Token token = null;
        for (int i2 = 0; i2 < format.length(); ++i2) {
            char c2 = format.charAt(i2);
            if (bl && c2 != '\'') {
                stringBuilder.append(c2);
                continue;
            }
            Object object = null;
            switch (c2) {
                case '\'': {
                    if (bl) {
                        stringBuilder = null;
                        bl = false;
                        break;
                    }
                    stringBuilder = new StringBuilder();
                    arrayList.add(new Token(stringBuilder));
                    bl = true;
                    break;
                }
                case 'y': {
                    object = y;
                    break;
                }
                case 'M': {
                    object = M;
                    break;
                }
                case 'd': {
                    object = d;
                    break;
                }
                case 'H': {
                    object = H;
                    break;
                }
                case 'm': {
                    object = m;
                    break;
                }
                case 's': {
                    object = s;
                    break;
                }
                case 'S': {
                    object = S;
                    break;
                }
                default: {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                        arrayList.add(new Token(stringBuilder));
                    }
                    stringBuilder.append(c2);
                }
            }
            if (object == null) continue;
            if (token != null && token.getValue().equals(object)) {
                token.increment();
            } else {
                Token token2 = new Token(object);
                arrayList.add(token2);
                token = token2;
            }
            stringBuilder = null;
        }
        if (bl) {
            throw new IllegalArgumentException("Unmatched quote in format: " + format);
        }
        ArrayList<Token> arrayList2 = arrayList;
        return arrayList2.toArray(new Token[arrayList2.size()]);
    }

    static class Token {
        private final Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            Token[] tokenArray = tokens;
            int n2 = tokens.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Token token = tokenArray[i2];
                if (token.getValue() != value) continue;
                return true;
            }
            return false;
        }

        Token(Object value) {
            this.value = value;
            this.count = 1;
        }

        Token(Object value, int count) {
            this.value = value;
            this.count = count;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token token = (Token)obj2;
                if (this.value.getClass() != token.value.getClass()) {
                    return false;
                }
                if (this.count != token.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(token.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(token.value);
                }
                return this.value == token.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

