/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public class SimpleLog
implements Serializable,
Log {
    private static final long serialVersionUID = 136942970684951178L;
    protected static final String systemPrefix = "org.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps = new Properties();
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static volatile boolean showLogName = false;
    protected static volatile boolean showShortName = true;
    protected static volatile boolean showDateTime = false;
    protected static volatile String dateTimeFormat = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected volatile String logName = null;
    protected volatile int currentLogLevel;
    private volatile String shortLogName = null;
    static Class class$java$lang$Thread;
    static Class class$org$apache$commons$logging$impl$SimpleLog;

    private static String getStringProperty(String name) {
        String string = null;
        try {
            string = System.getProperty(name);
        }
        catch (SecurityException securityException) {}
        if (string == null) {
            return simpleLogProps.getProperty(name);
        }
        return string;
    }

    private static String getStringProperty(String name, String dephault) {
        String string = SimpleLog.getStringProperty(name);
        if (string == null) {
            return dephault;
        }
        return string;
    }

    private static boolean getBooleanProperty(String name, boolean dephault) {
        String string = SimpleLog.getStringProperty(name);
        if (string == null) {
            return dephault;
        }
        return "true".equalsIgnoreCase(string);
    }

    public SimpleLog(String name) {
        this.logName = name;
        this.setLevel(3);
        String string = SimpleLog.getStringProperty("org.apache.commons.logging.simplelog.log." + this.logName);
        int n2 = String.valueOf(name).lastIndexOf(".");
        while (string == null && n2 >= 0) {
            name = name.substring(0, n2);
            string = SimpleLog.getStringProperty("org.apache.commons.logging.simplelog.log." + name);
            n2 = String.valueOf(name).lastIndexOf(".");
        }
        if (string == null) {
            string = SimpleLog.getStringProperty("org.apache.commons.logging.simplelog.defaultlog");
        }
        if ("all".equalsIgnoreCase(string)) {
            this.setLevel(0);
            return;
        }
        if ("trace".equalsIgnoreCase(string)) {
            this.setLevel(1);
            return;
        }
        if ("debug".equalsIgnoreCase(string)) {
            this.setLevel(2);
            return;
        }
        if ("info".equalsIgnoreCase(string)) {
            this.setLevel(3);
            return;
        }
        if ("warn".equalsIgnoreCase(string)) {
            this.setLevel(4);
            return;
        }
        if ("error".equalsIgnoreCase(string)) {
            this.setLevel(5);
            return;
        }
        if ("fatal".equalsIgnoreCase(string)) {
            this.setLevel(6);
            return;
        }
        if ("off".equalsIgnoreCase(string)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(int type, Object message, Throwable t2) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            object2 = new Date();
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                object = dateFormatter.format((Date)object2);
            }
            stringBuffer.append((String)object);
            stringBuffer.append(" ");
        }
        switch (type) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuffer.append("[INFO] ");
                break;
            }
            case 4: {
                stringBuffer.append("[WARN] ");
                break;
            }
            case 5: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuffer.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                Object object3 = object2 = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = ((String)object3).substring(((String)object3).lastIndexOf("/") + 1);
            }
            stringBuffer.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(message));
        if (t2 != null) {
            stringBuffer.append(" <");
            stringBuffer.append(t2.toString());
            stringBuffer.append(">");
            object2 = new StringWriter(1024);
            object = new PrintWriter((Writer)object2);
            t2.printStackTrace((PrintWriter)object);
            ((PrintWriter)object).close();
            stringBuffer.append(((StringWriter)object2).toString());
        }
        this.write(stringBuffer);
    }

    protected void write(StringBuffer buffer) {
        System.err.println(buffer.toString());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public final void debug(Object message) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, null);
        }
    }

    public final void debug(Object message, Throwable t2) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, t2);
        }
    }

    public final void trace(Object message) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, null);
        }
    }

    public final void trace(Object message, Throwable t2) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, t2);
        }
    }

    public final void info(Object message) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, null);
        }
    }

    public final void info(Object message, Throwable t2) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, t2);
        }
    }

    public final void warn(Object message) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, null);
        }
    }

    public final void warn(Object message, Throwable t2) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, t2);
        }
    }

    public final void error(Object message) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, null);
        }
    }

    public final void error(Object message, Throwable t2) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, t2);
        }
    }

    public final void fatal(Object message) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, null);
        }
    }

    public final void fatal(Object message, Throwable t2) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, t2);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = SimpleLog.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", invocationTargetException2.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (classLoader == null) {
            classLoader = (class$org$apache$commons$logging$impl$SimpleLog == null ? (class$org$apache$commons$logging$impl$SimpleLog = SimpleLog.class$("org.apache.commons.logging.impl.SimpleLog")) : class$org$apache$commons$logging$impl$SimpleLog).getClassLoader();
        }
        return classLoader;
    }

    private static InputStream getResourceAsStream(String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(name){
            private final String val$name;
            {
                this.val$name = string;
            }

            public final Object run() {
                ClassLoader classLoader = SimpleLog.access$000();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(this.val$name);
                }
                return ClassLoader.getSystemResourceAsStream(this.val$name);
            }
        });
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ClassLoader access$000() {
        return SimpleLog.getContextClassLoader();
    }

    static {
        InputStream inputStream = SimpleLog.getResourceAsStream("simplelog.properties");
        if (inputStream != null) {
            try {
                simpleLogProps.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        showLogName = SimpleLog.getBooleanProperty("org.apache.commons.logging.simplelog.showlogname", showLogName);
        showShortName = SimpleLog.getBooleanProperty("org.apache.commons.logging.simplelog.showShortLogname", showShortName);
        if (showDateTime = SimpleLog.getBooleanProperty("org.apache.commons.logging.simplelog.showdatetime", showDateTime)) {
            dateTimeFormat = SimpleLog.getStringProperty("org.apache.commons.logging.simplelog.dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }
}

