/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.text.StrBuilder;
import org.apache.commons.text.StrMatcher;

public class StrTokenizer
implements Cloneable,
ListIterator<String> {
    private static final StrTokenizer CSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
    private static final StrTokenizer TSV_TOKENIZER_PROTOTYPE;
    private char[] chars;
    private String[] tokens;
    private int tokenPos;
    private StrMatcher delimMatcher = StrMatcher.splitMatcher();
    private StrMatcher quoteMatcher = StrMatcher.noneMatcher();
    private StrMatcher ignoredMatcher = StrMatcher.noneMatcher();
    private StrMatcher trimmerMatcher = StrMatcher.noneMatcher();
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = true;

    private static StrTokenizer getCSVClone() {
        return (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getCSVInstance() {
        return StrTokenizer.getCSVClone();
    }

    public static StrTokenizer getCSVInstance(String input) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVClone();
        strTokenizer.reset(input);
        return strTokenizer;
    }

    public static StrTokenizer getCSVInstance(char[] input) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVClone();
        strTokenizer.reset(input);
        return strTokenizer;
    }

    private static StrTokenizer getTSVClone() {
        return (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getTSVInstance() {
        return StrTokenizer.getTSVClone();
    }

    public static StrTokenizer getTSVInstance(String input) {
        StrTokenizer strTokenizer = StrTokenizer.getTSVClone();
        strTokenizer.reset(input);
        return strTokenizer;
    }

    public static StrTokenizer getTSVInstance(char[] input) {
        StrTokenizer strTokenizer = StrTokenizer.getTSVClone();
        strTokenizer.reset(input);
        return strTokenizer;
    }

    public StrTokenizer() {
        this.chars = null;
    }

    public StrTokenizer(String input) {
        if (input != null) {
            this.chars = input.toCharArray();
            return;
        }
        this.chars = null;
    }

    public StrTokenizer(String input, char delim) {
        this(input);
        this.setDelimiterChar(delim);
    }

    public StrTokenizer(String input, String delim) {
        this(input);
        this.setDelimiterString(delim);
    }

    public StrTokenizer(String input, StrMatcher delim) {
        this(input);
        this.setDelimiterMatcher(delim);
    }

    public StrTokenizer(String input, char delim, char quote) {
        this(input, delim);
        this.setQuoteChar(quote);
    }

    public StrTokenizer(String input, StrMatcher delim, StrMatcher quote) {
        this(input, delim);
        this.setQuoteMatcher(quote);
    }

    public StrTokenizer(char[] input) {
        if (input == null) {
            this.chars = null;
            return;
        }
        this.chars = (char[])input.clone();
    }

    public StrTokenizer(char[] input, char delim) {
        this(input);
        this.setDelimiterChar(delim);
    }

    public StrTokenizer(char[] input, String delim) {
        this(input);
        this.setDelimiterString(delim);
    }

    public StrTokenizer(char[] input, StrMatcher delim) {
        this(input);
        this.setDelimiterMatcher(delim);
    }

    public StrTokenizer(char[] input, char delim, char quote) {
        this(input, delim);
        this.setQuoteChar(quote);
    }

    public StrTokenizer(char[] input, StrMatcher delim, StrMatcher quote) {
        this(input, delim);
        this.setQuoteMatcher(quote);
    }

    public int size() {
        this.checkTokenized();
        return this.tokens.length;
    }

    public String nextToken() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        return null;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        return null;
    }

    public String[] getTokenArray() {
        this.checkTokenized();
        return (String[])this.tokens.clone();
    }

    public List<String> getTokenList() {
        this.checkTokenized();
        ArrayList<String> arrayList = new ArrayList<String>(this.tokens.length);
        String[] stringArray = this.tokens;
        int n2 = this.tokens.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            arrayList.add(string);
        }
        return arrayList;
    }

    public StrTokenizer reset() {
        this.tokenPos = 0;
        this.tokens = null;
        return this;
    }

    public StrTokenizer reset(String input) {
        this.reset();
        this.chars = (char[])(input != null ? input.toCharArray() : null);
        return this;
    }

    public StrTokenizer reset(char[] input) {
        this.reset();
        this.chars = (char[])(input != null ? (char[])input.clone() : null);
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkTokenized();
        return this.tokenPos < this.tokens.length;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    @Override
    public boolean hasPrevious() {
        this.checkTokenized();
        return this.tokenPos > 0;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.tokenPos - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    @Override
    public void set(String obj) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    @Override
    public void add(String obj) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    private void checkTokenized() {
        if (this.tokens == null) {
            List<String> list;
            if (this.chars == null) {
                List<String> list2;
                List<String> list3 = list2 = this.tokenize(null, 0, 0);
                this.tokens = list3.toArray(new String[list3.size()]);
                return;
            }
            StrTokenizer strTokenizer = this;
            List<String> list4 = list = strTokenizer.tokenize(strTokenizer.chars, 0, this.chars.length);
            this.tokens = list4.toArray(new String[list4.size()]);
        }
    }

    protected List<String> tokenize(char[] srcChars, int offset, int count) {
        if (srcChars == null || count == 0) {
            return Collections.emptyList();
        }
        StrBuilder strBuilder = new StrBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = offset;
        while (n2 >= 0 && n2 < count) {
            if ((n2 = this.readNextToken(srcChars, n2, count, strBuilder, arrayList)) < count) continue;
            this.addToken(arrayList, "");
        }
        return arrayList;
    }

    private void addToken(List<String> list, String tok) {
        if (tok == null || tok.length() == 0) {
            if (this.isIgnoreEmptyTokens()) {
                return;
            }
            if (this.isEmptyTokenAsNull()) {
                tok = null;
            }
        }
        list.add(tok);
    }

    private int readNextToken(char[] srcChars, int start, int len, StrBuilder workArea, List<String> tokenList) {
        int n2;
        while (start < len) {
            int n3 = start;
            int n4 = start;
            n2 = Math.max(this.getIgnoredMatcher().isMatch(srcChars, n3, n3, len), this.getTrimmerMatcher().isMatch(srcChars, n4, n4, len));
            if (n2 == 0) break;
            int n5 = start;
            if (this.getDelimiterMatcher().isMatch(srcChars, n5, n5, len) > 0) break;
            int n6 = start;
            if (this.getQuoteMatcher().isMatch(srcChars, n6, n6, len) > 0) break;
            start += n2;
        }
        if (start >= len) {
            this.addToken(tokenList, "");
            return -1;
        }
        int n7 = start;
        n2 = this.getDelimiterMatcher().isMatch(srcChars, n7, n7, len);
        if (n2 > 0) {
            this.addToken(tokenList, "");
            return start + n2;
        }
        int n8 = start;
        int n9 = this.getQuoteMatcher().isMatch(srcChars, n8, n8, len);
        if (n9 > 0) {
            return this.readWithQuotes(srcChars, start + n9, len, workArea, tokenList, start, n9);
        }
        return this.readWithQuotes(srcChars, start, len, workArea, tokenList, 0, 0);
    }

    private int readWithQuotes(char[] srcChars, int start, int len, StrBuilder workArea, List<String> tokenList, int quoteStart, int quoteLen) {
        workArea.clear();
        int n2 = start;
        boolean bl = quoteLen > 0;
        int n3 = 0;
        while (n2 < len) {
            if (bl) {
                if (this.isQuote(srcChars, n2, len, quoteStart, quoteLen)) {
                    if (this.isQuote(srcChars, n2 + quoteLen, len, quoteStart, quoteLen)) {
                        workArea.append(srcChars, n2, quoteLen);
                        n2 += quoteLen << 1;
                        n3 = workArea.size();
                        continue;
                    }
                    bl = false;
                    n2 += quoteLen;
                    continue;
                }
                workArea.append(srcChars[n2++]);
                n3 = workArea.size();
                continue;
            }
            int n4 = this.getDelimiterMatcher().isMatch(srcChars, n2, start, len);
            if (n4 > 0) {
                this.addToken(tokenList, workArea.substring(0, n3));
                return n2 + n4;
            }
            if (quoteLen > 0 && this.isQuote(srcChars, n2, len, quoteStart, quoteLen)) {
                bl = true;
                n2 += quoteLen;
                continue;
            }
            int n5 = this.getIgnoredMatcher().isMatch(srcChars, n2, start, len);
            if (n5 > 0) {
                n2 += n5;
                continue;
            }
            int n6 = this.getTrimmerMatcher().isMatch(srcChars, n2, start, len);
            if (n6 > 0) {
                workArea.append(srcChars, n2, n6);
                n2 += n6;
                continue;
            }
            workArea.append(srcChars[n2++]);
            n3 = workArea.size();
        }
        this.addToken(tokenList, workArea.substring(0, n3));
        return -1;
    }

    private boolean isQuote(char[] srcChars, int pos, int len, int quoteStart, int quoteLen) {
        for (int i2 = 0; i2 < quoteLen; ++i2) {
            if (pos + i2 < len && srcChars[pos + i2] == srcChars[quoteStart + i2]) continue;
            return false;
        }
        return true;
    }

    public StrMatcher getDelimiterMatcher() {
        return this.delimMatcher;
    }

    public StrTokenizer setDelimiterMatcher(StrMatcher delim) {
        this.delimMatcher = delim == null ? StrMatcher.noneMatcher() : delim;
        return this;
    }

    public StrTokenizer setDelimiterChar(char delim) {
        return this.setDelimiterMatcher(StrMatcher.charMatcher(delim));
    }

    public StrTokenizer setDelimiterString(String delim) {
        return this.setDelimiterMatcher(StrMatcher.stringMatcher(delim));
    }

    public StrMatcher getQuoteMatcher() {
        return this.quoteMatcher;
    }

    public StrTokenizer setQuoteMatcher(StrMatcher quote) {
        if (quote != null) {
            this.quoteMatcher = quote;
        }
        return this;
    }

    public StrTokenizer setQuoteChar(char quote) {
        return this.setQuoteMatcher(StrMatcher.charMatcher(quote));
    }

    public StrMatcher getIgnoredMatcher() {
        return this.ignoredMatcher;
    }

    public StrTokenizer setIgnoredMatcher(StrMatcher ignored) {
        if (ignored != null) {
            this.ignoredMatcher = ignored;
        }
        return this;
    }

    public StrTokenizer setIgnoredChar(char ignored) {
        return this.setIgnoredMatcher(StrMatcher.charMatcher(ignored));
    }

    public StrMatcher getTrimmerMatcher() {
        return this.trimmerMatcher;
    }

    public StrTokenizer setTrimmerMatcher(StrMatcher trimmer) {
        if (trimmer != null) {
            this.trimmerMatcher = trimmer;
        }
        return this;
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public StrTokenizer setEmptyTokenAsNull(boolean emptyAsNull) {
        this.emptyAsNull = emptyAsNull;
        return this;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    public StrTokenizer setIgnoreEmptyTokens(boolean ignoreEmptyTokens) {
        this.ignoreEmptyTokens = ignoreEmptyTokens;
        return this;
    }

    public String getContent() {
        if (this.chars == null) {
            return null;
        }
        return new String(this.chars);
    }

    public Object clone() {
        try {
            return this.cloneReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object cloneReset() throws CloneNotSupportedException {
        StrTokenizer strTokenizer = (StrTokenizer)super.clone();
        if (strTokenizer.chars != null) {
            strTokenizer.chars = (char[])strTokenizer.chars.clone();
        }
        strTokenizer.reset();
        return strTokenizer;
    }

    public String toString() {
        if (this.tokens == null) {
            return "StrTokenizer[not tokenized yet]";
        }
        return "StrTokenizer" + this.getTokenList();
    }

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.commaMatcher());
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        CSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.tabMatcher());
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        TSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }
}

