/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

final class GJYearOfEraDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = -5961050944769862059L;
    private final BasicChronology iChronology;

    GJYearOfEraDateTimeField(DateTimeField dateTimeField, BasicChronology basicChronology) {
        super(dateTimeField, DateTimeFieldType.yearOfEra());
        this.iChronology = basicChronology;
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.eras();
    }

    public final int get(long l2) {
        int n2 = this.getWrappedField().get(l2);
        if (n2 <= 0) {
            n2 = 1 - n2;
        }
        return n2;
    }

    public final long add(long l2, int n2) {
        return this.getWrappedField().add(l2, n2);
    }

    public final long add(long l2, long l3) {
        return this.getWrappedField().add(l2, l3);
    }

    public final long addWrapField(long l2, int n2) {
        return this.getWrappedField().addWrapField(l2, n2);
    }

    public final int[] addWrapField(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        return this.getWrappedField().addWrapField(readablePartial, n2, nArray, n3);
    }

    public final int getDifference(long l2, long l3) {
        return this.getWrappedField().getDifference(l2, l3);
    }

    public final long getDifferenceAsLong(long l2, long l3) {
        return this.getWrappedField().getDifferenceAsLong(l2, l3);
    }

    public final long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, 1, this.getMaximumValue());
        if (this.iChronology.getYear(l2) <= 0) {
            n2 = 1 - n2;
        }
        return super.set(l2, n2);
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return this.getWrappedField().getMaximumValue();
    }

    public final long roundFloor(long l2) {
        return this.getWrappedField().roundFloor(l2);
    }

    public final long roundCeiling(long l2) {
        return this.getWrappedField().roundCeiling(l2);
    }

    public final long remainder(long l2) {
        return this.getWrappedField().remainder(l2);
    }

    private Object readResolve() {
        return this.iChronology.yearOfEra();
    }
}

