/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public final class MillisDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = 2656707858124633367L;
    public static final DurationField INSTANCE = new MillisDurationField();

    private MillisDurationField() {
    }

    public final DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    public final String getName() {
        return "millis";
    }

    public final boolean isSupported() {
        return true;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return 1L;
    }

    public final int getValue(long l2) {
        return FieldUtils.safeToInt(l2);
    }

    public final long getValueAsLong(long l2) {
        return l2;
    }

    public final int getValue(long l2, long l3) {
        return FieldUtils.safeToInt(l2);
    }

    public final long getValueAsLong(long l2, long l3) {
        return l2;
    }

    public final long getMillis(int n2) {
        return n2;
    }

    public final long getMillis(long l2) {
        return l2;
    }

    public final long getMillis(int n2, long l2) {
        return n2;
    }

    public final long getMillis(long l2, long l3) {
        return l2;
    }

    public final long add(long l2, int n2) {
        return FieldUtils.safeAdd(l2, (long)n2);
    }

    public final long add(long l2, long l3) {
        return FieldUtils.safeAdd(l2, l3);
    }

    public final int getDifference(long l2, long l3) {
        return FieldUtils.safeToInt(FieldUtils.safeSubtract(l2, l3));
    }

    public final long getDifferenceAsLong(long l2, long l3) {
        return FieldUtils.safeSubtract(l2, l3);
    }

    public final int compareTo(DurationField durationField) {
        long l2 = durationField.getUnitMillis();
        long l3 = this.getUnitMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public final boolean equals(Object object) {
        if (object instanceof MillisDurationField) {
            return this.getUnitMillis() == ((MillisDurationField)object).getUnitMillis();
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.getUnitMillis();
    }

    public final String toString() {
        return "DurationField[millis]";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

