/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;

public abstract class PreciseDurationDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 5004523158306266035L;
    final long iUnitMillis;
    private final DurationField iUnitField;

    public PreciseDurationDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        super(dateTimeFieldType);
        if (!durationField.isPrecise()) {
            throw new IllegalArgumentException("Unit duration field must be precise");
        }
        this.iUnitMillis = durationField.getUnitMillis();
        if (this.iUnitMillis < 1L) {
            throw new IllegalArgumentException("The unit milliseconds must be at least 1");
        }
        this.iUnitField = durationField;
    }

    public boolean isLenient() {
        return false;
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.getMinimumValue(), this.getMaximumValueForSet(l2, n2));
        return l2 + (long)(n2 - this.get(l2)) * this.iUnitMillis;
    }

    public long roundFloor(long l2) {
        if (l2 >= 0L) {
            long l3 = l2;
            return l3 - l3 % this.iUnitMillis;
        }
        return ++l2 - l2 % this.iUnitMillis - this.iUnitMillis;
    }

    public long roundCeiling(long l2) {
        if (l2 > 0L) {
            return --l2 - l2 % this.iUnitMillis + this.iUnitMillis;
        }
        long l3 = l2;
        return l3 - l3 % this.iUnitMillis;
    }

    public long remainder(long l2) {
        if (l2 >= 0L) {
            return l2 % this.iUnitMillis;
        }
        return (l2 + 1L) % this.iUnitMillis + this.iUnitMillis - 1L;
    }

    public DurationField getDurationField() {
        return this.iUnitField;
    }

    public int getMinimumValue() {
        return 0;
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    protected int getMaximumValueForSet(long l2, int n2) {
        return this.getMaximumValue(l2);
    }
}

