/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static final long serialVersionUID = -1934618396111902255L;
    private static HashMap<DateTimeFieldType, UnsupportedDateTimeField> cCache;
    private final DateTimeFieldType iType;
    private final DurationField iDurationField;

    public static synchronized UnsupportedDateTimeField getInstance(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        UnsupportedDateTimeField unsupportedDateTimeField;
        if (cCache == null) {
            cCache = new HashMap(7);
            unsupportedDateTimeField = null;
        } else {
            unsupportedDateTimeField = cCache.get(dateTimeFieldType);
            if (unsupportedDateTimeField != null && unsupportedDateTimeField.getDurationField() != durationField) {
                unsupportedDateTimeField = null;
            }
        }
        if (unsupportedDateTimeField == null) {
            unsupportedDateTimeField = new UnsupportedDateTimeField(dateTimeFieldType, durationField);
            cCache.put(dateTimeFieldType, unsupportedDateTimeField);
        }
        return unsupportedDateTimeField;
    }

    private UnsupportedDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        if (dateTimeFieldType == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = dateTimeFieldType;
        this.iDurationField = durationField;
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return false;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l2) {
        throw this.unsupported();
    }

    public final String getAsText(long l2, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsText(long l2) {
        throw this.unsupported();
    }

    public final String getAsText(ReadablePartial readablePartial, int n2, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsText(ReadablePartial readablePartial, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsText(int n2, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsShortText(long l2, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsShortText(long l2) {
        throw this.unsupported();
    }

    public final String getAsShortText(ReadablePartial readablePartial, int n2, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsShortText(ReadablePartial readablePartial, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsShortText(int n2, Locale locale) {
        throw this.unsupported();
    }

    public final long add(long l2, int n2) {
        return this.getDurationField().add(l2, n2);
    }

    public final long add(long l2, long l3) {
        return this.getDurationField().add(l2, l3);
    }

    public final int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    public final int[] addWrapPartial(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    public final long addWrapField(long l2, int n2) {
        throw this.unsupported();
    }

    public final int[] addWrapField(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    public final int getDifference(long l2, long l3) {
        return this.getDurationField().getDifference(l2, l3);
    }

    public final long getDifferenceAsLong(long l2, long l3) {
        return this.getDurationField().getDifferenceAsLong(l2, l3);
    }

    public final long set(long l2, int n2) {
        throw this.unsupported();
    }

    public final int[] set(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    public final long set(long l2, String string, Locale locale) {
        throw this.unsupported();
    }

    public final long set(long l2, String string) {
        throw this.unsupported();
    }

    public final int[] set(ReadablePartial readablePartial, int n2, int[] nArray, String string, Locale locale) {
        throw this.unsupported();
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public final DurationField getRangeDurationField() {
        return null;
    }

    public final boolean isLeap(long l2) {
        throw this.unsupported();
    }

    public final int getLeapAmount(long l2) {
        throw this.unsupported();
    }

    public final DurationField getLeapDurationField() {
        return null;
    }

    public final int getMinimumValue() {
        throw this.unsupported();
    }

    public final int getMinimumValue(long l2) {
        throw this.unsupported();
    }

    public final int getMinimumValue(ReadablePartial readablePartial) {
        throw this.unsupported();
    }

    public final int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
        throw this.unsupported();
    }

    public final int getMaximumValue() {
        throw this.unsupported();
    }

    public final int getMaximumValue(long l2) {
        throw this.unsupported();
    }

    public final int getMaximumValue(ReadablePartial readablePartial) {
        throw this.unsupported();
    }

    public final int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        throw this.unsupported();
    }

    public final int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    public final int getMaximumShortTextLength(Locale locale) {
        throw this.unsupported();
    }

    public final long roundFloor(long l2) {
        throw this.unsupported();
    }

    public final long roundCeiling(long l2) {
        throw this.unsupported();
    }

    public final long roundHalfFloor(long l2) {
        throw this.unsupported();
    }

    public final long roundHalfCeiling(long l2) {
        throw this.unsupported();
    }

    public final long roundHalfEven(long l2) {
        throw this.unsupported();
    }

    public final long remainder(long l2) {
        throw this.unsupported();
    }

    public final String toString() {
        return "UnsupportedDateTimeField";
    }

    private Object readResolve() {
        return UnsupportedDateTimeField.getInstance(this.iType, this.iDurationField);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }
}

