/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchMatMul<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> BatchMatMul<T> create(Scope scope, Operand<T> x2, Operand<T> y2, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BatchMatMul", scope.makeOpName("BatchMatMul"));
        operationBuilder.addInput(x2.asOutput());
        operationBuilder.addInput(y2.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.adjX != null) {
                    operationBuilder.setAttr("adj_x", options2.adjX);
                }
                if (options2.adjY == null) continue;
                operationBuilder.setAttr("adj_y", options2.adjY);
            }
        }
        return new BatchMatMul<T>(operationBuilder.build());
    }

    public static Options adjX(Boolean adjX) {
        return new Options().adjX(adjX);
    }

    public static Options adjY(Boolean adjY) {
        return new Options().adjY(adjY);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private BatchMatMul(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean adjX;
        private Boolean adjY;

        public Options adjX(Boolean adjX) {
            this.adjX = adjX;
            return this;
        }

        public Options adjY(Boolean adjY) {
            this.adjY = adjY;
            return this;
        }

        private Options() {
        }
    }
}

