/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Cumprod<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> out;

    public static <T, U extends Number> Cumprod<T> create(Scope scope, Operand<T> x2, Operand<U> axis, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Cumprod", scope.makeOpName("Cumprod"));
        operationBuilder.addInput(x2.asOutput());
        operationBuilder.addInput(axis.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.exclusive != null) {
                    operationBuilder.setAttr("exclusive", options2.exclusive);
                }
                if (options2.reverse == null) continue;
                operationBuilder.setAttr("reverse", options2.reverse);
            }
        }
        return new Cumprod<T>(operationBuilder.build());
    }

    public static Options exclusive(Boolean exclusive) {
        return new Options().exclusive(exclusive);
    }

    public static Options reverse(Boolean reverse) {
        return new Options().reverse(reverse);
    }

    public final Output<T> out() {
        return this.out;
    }

    @Override
    public final Output<T> asOutput() {
        return this.out;
    }

    private Cumprod(Operation operation) {
        super(operation);
        this.out = operation.output(0);
    }

    public static class Options {
        private Boolean exclusive;
        private Boolean reverse;

        public Options exclusive(Boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public Options reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        private Options() {
        }
    }
}

