/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeProtoV2
extends PrimitiveOp {
    private Output<Integer> sizes;
    private List<Output<?>> values;

    public static DecodeProtoV2 create(Scope scope, Operand<String> bytes, String messageType, List<String> fieldNames, List<Class<?>> outputTypes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DecodeProtoV2", scope.makeOpName("DecodeProtoV2"));
        operationBuilder.addInput(bytes.asOutput());
        operationBuilder.setAttr("message_type", messageType);
        String[] stringArray = new String[fieldNames.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = fieldNames.get(i2);
        }
        operationBuilder.setAttr("field_names", stringArray);
        DataType[] dataTypeArray = new DataType[outputTypes.size()];
        for (int i3 = 0; i3 < dataTypeArray.length; ++i3) {
            dataTypeArray[i3] = DataType.fromClass(outputTypes.get(i3));
        }
        operationBuilder.setAttr("output_types", dataTypeArray);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                Options options2 = optionsArray[i4];
                if (options2.descriptorSource != null) {
                    operationBuilder.setAttr("descriptor_source", options2.descriptorSource);
                }
                if (options2.messageFormat != null) {
                    operationBuilder.setAttr("message_format", options2.messageFormat);
                }
                if (options2.sanitize == null) continue;
                operationBuilder.setAttr("sanitize", options2.sanitize);
            }
        }
        return new DecodeProtoV2(operationBuilder.build());
    }

    public static Options descriptorSource(String descriptorSource) {
        return new Options().descriptorSource(descriptorSource);
    }

    public static Options messageFormat(String messageFormat) {
        return new Options().messageFormat(messageFormat);
    }

    public static Options sanitize(Boolean sanitize) {
        return new Options().sanitize(sanitize);
    }

    public final Output<Integer> sizes() {
        return this.sizes;
    }

    public final List<Output<?>> values() {
        return this.values;
    }

    private DecodeProtoV2(Operation operation) {
        super(operation);
        this.sizes = operation.output(0);
        int n2 = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(1, n2));
    }

    public static class Options {
        private String descriptorSource;
        private String messageFormat;
        private Boolean sanitize;

        public Options descriptorSource(String descriptorSource) {
            this.descriptorSource = descriptorSource;
            return this;
        }

        public Options messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        public Options sanitize(Boolean sanitize) {
            this.sanitize = sanitize;
            return this;
        }

        private Options() {
        }
    }
}

