/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FakeQuantWithMinMaxArgsGradient
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> backprops;

    public static FakeQuantWithMinMaxArgsGradient create(Scope scope, Operand<Float> gradients, Operand<Float> inputs, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxArgsGradient", scope.makeOpName("FakeQuantWithMinMaxArgsGradient"));
        operationBuilder.addInput(gradients.asOutput());
        operationBuilder.addInput(inputs.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.min != null) {
                    operationBuilder.setAttr("min", options2.min.floatValue());
                }
                if (options2.max != null) {
                    operationBuilder.setAttr("max", options2.max.floatValue());
                }
                if (options2.numBits != null) {
                    operationBuilder.setAttr("num_bits", options2.numBits);
                }
                if (options2.narrowRange == null) continue;
                operationBuilder.setAttr("narrow_range", options2.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxArgsGradient(operationBuilder.build());
    }

    public static Options min(Float min) {
        return new Options().min(min);
    }

    public static Options max(Float max) {
        return new Options().max(max);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public final Output<Float> backprops() {
        return this.backprops;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.backprops;
    }

    private FakeQuantWithMinMaxArgsGradient(Operation operation) {
        super(operation);
        this.backprops = operation.output(0);
    }

    public static class Options {
        private Float min;
        private Float max;
        private Long numBits;
        private Boolean narrowRange;

        public Options min(Float min) {
            this.min = min;
            return this;
        }

        public Options max(Float max) {
            this.max = max;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

