/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FakeQuantWithMinMaxVarsPerChannel
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> outputs;

    public static FakeQuantWithMinMaxVarsPerChannel create(Scope scope, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxVarsPerChannel", scope.makeOpName("FakeQuantWithMinMaxVarsPerChannel"));
        operationBuilder.addInput(inputs.asOutput());
        operationBuilder.addInput(min.asOutput());
        operationBuilder.addInput(max.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.numBits != null) {
                    operationBuilder.setAttr("num_bits", options2.numBits);
                }
                if (options2.narrowRange == null) continue;
                operationBuilder.setAttr("narrow_range", options2.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVarsPerChannel(operationBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public final Output<Float> outputs() {
        return this.outputs;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.outputs;
    }

    private FakeQuantWithMinMaxVarsPerChannel(Operation operation) {
        super(operation);
        this.outputs = operation.output(0);
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

