/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedBatchNormV2<T extends Number, U extends Number>
extends PrimitiveOp {
    private Output<T> y;
    private Output<U> batchMean;
    private Output<U> batchVariance;
    private Output<U> reserveSpace1;
    private Output<U> reserveSpace2;

    public static <T extends Number, U extends Number> FusedBatchNormV2<T, U> create(Scope scope, Operand<T> x2, Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FusedBatchNormV2", scope.makeOpName("FusedBatchNormV2"));
        operationBuilder.addInput(x2.asOutput());
        operationBuilder.addInput(scale.asOutput());
        operationBuilder.addInput(offset.asOutput());
        operationBuilder.addInput(mean.asOutput());
        operationBuilder.addInput(variance.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.epsilon != null) {
                    operationBuilder.setAttr("epsilon", options2.epsilon.floatValue());
                }
                if (options2.dataFormat != null) {
                    operationBuilder.setAttr("data_format", options2.dataFormat);
                }
                if (options2.isTraining == null) continue;
                operationBuilder.setAttr("is_training", options2.isTraining);
            }
        }
        return new FusedBatchNormV2<T, U>(operationBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public final Output<T> y() {
        return this.y;
    }

    public final Output<U> batchMean() {
        return this.batchMean;
    }

    public final Output<U> batchVariance() {
        return this.batchVariance;
    }

    public final Output<U> reserveSpace1() {
        return this.reserveSpace1;
    }

    public final Output<U> reserveSpace2() {
        return this.reserveSpace2;
    }

    private FusedBatchNormV2(Operation operation) {
        super(operation);
        this.y = operation.output(0);
        this.batchMean = operation.output(1);
        this.batchVariance = operation.output(2);
        this.reserveSpace1 = operation.output(3);
        this.reserveSpace2 = operation.output(4);
    }

    public static class Options {
        private Float epsilon;
        private String dataFormat;
        private Boolean isTraining;

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }

        private Options() {
        }
    }
}

