/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class GenerateVocabRemapping
extends PrimitiveOp {
    private Output<Long> remapping;
    private Output<Integer> numPresent;

    public static GenerateVocabRemapping create(Scope scope, Operand<String> newVocabFile, Operand<String> oldVocabFile, Long newVocabOffset, Long numNewVocab, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("GenerateVocabRemapping", scope.makeOpName("GenerateVocabRemapping"));
        operationBuilder.addInput(newVocabFile.asOutput());
        operationBuilder.addInput(oldVocabFile.asOutput());
        operationBuilder.setAttr("new_vocab_offset", newVocabOffset);
        operationBuilder.setAttr("num_new_vocab", numNewVocab);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.oldVocabSize == null) continue;
                operationBuilder.setAttr("old_vocab_size", options2.oldVocabSize);
            }
        }
        return new GenerateVocabRemapping(operationBuilder.build());
    }

    public static Options oldVocabSize(Long oldVocabSize) {
        return new Options().oldVocabSize(oldVocabSize);
    }

    public final Output<Long> remapping() {
        return this.remapping;
    }

    public final Output<Integer> numPresent() {
        return this.numPresent;
    }

    private GenerateVocabRemapping(Operation operation) {
        super(operation);
        this.remapping = operation.output(0);
        this.numPresent = operation.output(1);
    }

    public static class Options {
        private Long oldVocabSize;

        public Options oldVocabSize(Long oldVocabSize) {
            this.oldVocabSize = oldVocabSize;
            return this;
        }

        private Options() {
        }
    }
}

