/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class NonMaxSuppressionV4
extends PrimitiveOp {
    private Output<Integer> selectedIndices;
    private Output<Integer> validOutputs;

    public static <T extends Number> NonMaxSuppressionV4 create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold, Operand<Float> scoreThreshold, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("NonMaxSuppressionV4", scope.makeOpName("NonMaxSuppressionV4"));
        operationBuilder.addInput(boxes.asOutput());
        operationBuilder.addInput(scores.asOutput());
        operationBuilder.addInput(maxOutputSize.asOutput());
        operationBuilder.addInput(iouThreshold.asOutput());
        operationBuilder.addInput(scoreThreshold.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.padToMaxOutputSize == null) continue;
                operationBuilder.setAttr("pad_to_max_output_size", options2.padToMaxOutputSize);
            }
        }
        return new NonMaxSuppressionV4(operationBuilder.build());
    }

    public static Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
        return new Options().padToMaxOutputSize(padToMaxOutputSize);
    }

    public final Output<Integer> selectedIndices() {
        return this.selectedIndices;
    }

    public final Output<Integer> validOutputs() {
        return this.validOutputs;
    }

    private NonMaxSuppressionV4(Operation operation) {
        super(operation);
        this.selectedIndices = operation.output(0);
        this.validOutputs = operation.output(1);
    }

    public static class Options {
        private Boolean padToMaxOutputSize;

        public Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
            this.padToMaxOutputSize = padToMaxOutputSize;
            return this;
        }

        private Options() {
        }
    }
}

