/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class OneHot<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> output;

    public static <U, T extends Number> OneHot<U> create(Scope scope, Operand<T> indices, Operand<Integer> depth, Operand<U> onValue, Operand<U> offValue, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("OneHot", scope.makeOpName("OneHot"));
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInput(depth.asOutput());
        operationBuilder.addInput(onValue.asOutput());
        operationBuilder.addInput(offValue.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.axis == null) continue;
                operationBuilder.setAttr("axis", options2.axis);
            }
        }
        return new OneHot<U>(operationBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public final Output<U> output() {
        return this.output;
    }

    @Override
    public final Output<U> asOutput() {
        return this.output;
    }

    private OneHot(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Long axis;

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

