/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Placeholder<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Placeholder<T> create(Scope scope, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Placeholder", scope.makeOpName("Placeholder"));
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.shape == null) continue;
                operationBuilder.setAttr("shape", options2.shape);
            }
        }
        return new Placeholder<T>(operationBuilder.build());
    }

    public static Options shape(Shape shape) {
        return new Options().shape(shape);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Placeholder(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Shape shape;

        public Options shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        private Options() {
        }
    }
}

