/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RandomCrop<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> RandomCrop<T> create(Scope scope, Operand<T> image, Operand<Long> size, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("RandomCrop", scope.makeOpName("RandomCrop"));
        operationBuilder.addInput(image.asOutput());
        operationBuilder.addInput(size.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 == null) continue;
                operationBuilder.setAttr("seed2", options2.seed2);
            }
        }
        return new RandomCrop<T>(operationBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private RandomCrop(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

